/*
 * LoginDialog.java
 *
 * Created on 22. August 2003, 13:04
 */

package de.jpilot.app.client;

import java.awt.*;
import java.awt.Dimension;
import java.awt.Toolkit;

/**
 *
 * @author  Herkules
 */
public class LoginDialog extends javax.swing.JDialog
{

	private boolean mDoExit = false;
		
	/** 
	 * Creates new form LoginDialog.
	 */
	public LoginDialog( Frame parent, boolean modal )
	{
		super(parent, modal);
		initComponents();
		initCustom();
		this.pack();
		this.center();
	}

	
	/**
	 * Do my own init stuff.
	 */
	private void initCustom()
	{
		String username = System.getProperty( "user.name" );
		mTextFieldName.setText( username );
		getRootPane().setDefaultButton( mButtonConnect );
	}
	
	public boolean doExit()
	{
		return mDoExit;
	}
	
	
	public boolean goFullscreen()
	{
		return mCheckBoxFullscreen.isSelected();
	}

	
	public String getUserName()
	{
		return mTextFieldName.getText().trim();
	}

	public void setServerName( String name )
	{
		mTextFieldServername.setText( name );
	}
	
	public String getServerName()
	{
		if ( getIsLocalServer() )
			return "localhost";
		return mTextFieldServername.getText();
	}
	
	public int getServerPort()
	{
		return Integer.parseInt( mTextFieldPort.getText() );
	}
	
	public boolean getIsLocalServer()
	{
		return mCheckBoxAsServer.isSelected();
	}
	
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    private void initComponents()//GEN-BEGIN:initComponents
    {
        javax.swing.JLabel mLabelName;
        javax.swing.JLabel mLabelPassword;
        javax.swing.JLabel mPortLabel;
        javax.swing.JLabel mServernameLabel;

        mNetOptionsPanel = new javax.swing.JPanel();
        mCheckBoxAsServer = new javax.swing.JCheckBox();
        mServernameLabel = new javax.swing.JLabel();
        mTextFieldServername = new javax.swing.JTextField();
        mPortLabel = new javax.swing.JLabel();
        mTextFieldPort = new javax.swing.JTextField();
        mButtonConnect = new javax.swing.JButton();
        mUserNamePanel = new javax.swing.JPanel();
        mLabelName = new javax.swing.JLabel();
        mTextFieldName = new javax.swing.JTextField();
        mLabelPassword = new javax.swing.JLabel();
        mPasswordField = new javax.swing.JPasswordField();
        mMiscPanel = new javax.swing.JPanel();
        mCheckBoxFullscreen = new javax.swing.JCheckBox();
        mButtonExit = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle("JPilot - login");
        setModal(true);
        setResizable(false);
        mNetOptionsPanel.setBorder(new javax.swing.border.TitledBorder("Server"));
        mCheckBoxAsServer.setText("as server");
        mCheckBoxAsServer.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                mCheckBoxAsServerActionPerformed(evt);
            }
        });

        mNetOptionsPanel.add(mCheckBoxAsServer);

        mServernameLabel.setText("Servername:");
        mNetOptionsPanel.add(mServernameLabel);

        mTextFieldServername.setText("localhost");
        mTextFieldServername.setPreferredSize(new java.awt.Dimension(150, 20));
        mNetOptionsPanel.add(mTextFieldServername);

        mPortLabel.setText("Port:");
        mNetOptionsPanel.add(mPortLabel);

        mTextFieldPort.setText("13664");
        mTextFieldPort.setPreferredSize(new java.awt.Dimension(50, 20));
        mNetOptionsPanel.add(mTextFieldPort);

        mButtonConnect.setText("Connect");
        mButtonConnect.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                mButtonConnectActionPerformed(evt);
            }
        });

        mNetOptionsPanel.add(mButtonConnect);

        getContentPane().add(mNetOptionsPanel, java.awt.BorderLayout.CENTER);

        mUserNamePanel.setBorder(new javax.swing.border.TitledBorder("Username"));
        mLabelName.setText("Name: ");
        mUserNamePanel.add(mLabelName);

        mTextFieldName.setPreferredSize(new java.awt.Dimension(150, 20));
        mUserNamePanel.add(mTextFieldName);

        mLabelPassword.setText("Password: ");
        mUserNamePanel.add(mLabelPassword);

        mPasswordField.setPreferredSize(new java.awt.Dimension(150, 20));
        mUserNamePanel.add(mPasswordField);

        getContentPane().add(mUserNamePanel, java.awt.BorderLayout.NORTH);

        mCheckBoxFullscreen.setText("fullscreen");
        mMiscPanel.add(mCheckBoxFullscreen);

        mButtonExit.setText("Exit");
        mButtonExit.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                mButtonExitActionPerformed(evt);
            }
        });

        mMiscPanel.add(mButtonExit);

        getContentPane().add(mMiscPanel, java.awt.BorderLayout.SOUTH);

    }//GEN-END:initComponents

	private void mButtonExitActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_mButtonExitActionPerformed
	{//GEN-HEADEREND:event_mButtonExitActionPerformed

		mDoExit = true;
		this.hide();
		
	}//GEN-LAST:event_mButtonExitActionPerformed

	private void mCheckBoxAsServerActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_mCheckBoxAsServerActionPerformed
	{//GEN-HEADEREND:event_mCheckBoxAsServerActionPerformed

		if ( mCheckBoxAsServer.isSelected() )
        {
//            mButtonConnect.setEnabled( false );
            mTextFieldServername.setEnabled( false );
//			mTextFieldServername.setText( "localhost" );
            try 
            {
                mTextFieldServername.setText( java.net.InetAddress.getLocalHost().toString() );
            }
            catch ( java.net.UnknownHostException uhex )
            {}
        }
        else
        {
//            mButtonConnect.setEnabled( true );
            mTextFieldServername.setEnabled( true );            
        }

	}//GEN-LAST:event_mCheckBoxAsServerActionPerformed

	private void mButtonConnectActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_mButtonConnectActionPerformed
	{//GEN-HEADEREND:event_mButtonConnectActionPerformed

		mDoExit = false;
		this.hide();
		
	}//GEN-LAST:event_mButtonConnectActionPerformed
	
	/** Closes the dialog */	
	
    private void center()
    {
        // Plonk it on center of screen
        Dimension WindowSize = getSize();
        Dimension ScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
        setBounds( ( ScreenSize.width - WindowSize.width ) / 2,
                ( ScreenSize.height - WindowSize.height ) / 2, WindowSize.width,
                WindowSize.height );
    }
	
	
	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[])
	{
		new LoginDialog(new javax.swing.JFrame(), true).show();
	}
	
	
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton mButtonConnect;
    private javax.swing.JButton mButtonExit;
    private javax.swing.JCheckBox mCheckBoxAsServer;
    private javax.swing.JCheckBox mCheckBoxFullscreen;
    private javax.swing.JPanel mMiscPanel;
    private javax.swing.JPanel mNetOptionsPanel;
    private javax.swing.JPasswordField mPasswordField;
    private javax.swing.JTextField mTextFieldName;
    private javax.swing.JTextField mTextFieldPort;
    private javax.swing.JTextField mTextFieldServername;
    private javax.swing.JPanel mUserNamePanel;
    // End of variables declaration//GEN-END:variables
	
}
