//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.app.client;

import de.jpilot.client.Client;
import de.jpilot.client.UserInfo;
import de.jpilot.graphicsengine.piccolo.PiccoloEngine;
import de.jpilot.app.server.Server;
import java.awt.*;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.swing.JOptionPane;

/**
 *
 * @author  Herkules
 */
public class JPilot extends javax.swing.JFrame
{
	private final	PiccoloEngine	mEngine = new PiccoloEngine( 800, 600 );
	private final	Client	mClt;
	private final	LoginDialog		mLogin	= new LoginDialog( this, true );

    DisplayMode     mDesktopMode = null;
    DisplayMode     mFullscreenMode = null;
	
    private final ArrayList mDisplayModes = new ArrayList();
	
	Server mServer	= null;
	
	/** Creates new form JPilot */
	public JPilot( String [] args )
	{
		initComponents();
		initCustom();
		this.pack();
		this.center();
		this.show();

		//
		// For now, take a single argument and take it as a default server.
		//
		if ( args.length == 1 )
			mLogin.setServerName( args[ 0 ] );

		UserInfo ui = new UserInfo();
//		ui.name = mLogin.getUserName();
		mClt	= new Client( mEngine, mEngine.createController(), ui );

		boolean connectSucceeded = false;
		
		while ( ! connectSucceeded )
		{
			mLogin.show();

			//
			// If the user wants to exit, do him the favor.
			//
			if ( mLogin.doExit() )
			{
				exitForm( null );
			}
			
			ui.name = mLogin.getUserName();

			if ( mLogin.getIsLocalServer() )
			{
				mServer = new Server( mLogin.getServerPort() );
				if ( ! mServer.isOperational() )
				{
					JOptionPane.showMessageDialog( this, "Cannot create local server!" );
					exitForm( null );
				}
			}

			try
			{
				String server = mLogin.getServerName().trim();
				connectSucceeded = mClt.connect( InetAddress.getByName( server ), mLogin.getServerPort() );
				if ( ! connectSucceeded )
				{
					JOptionPane.showMessageDialog( this, "Cannot connect to server!" );
//					exitForm( null );
				}
			}
			catch ( UnknownHostException uhex )
			{
				JOptionPane.showMessageDialog( this, "Servername invalid!" );
//				exitForm( null );
			}
			catch ( Exception ex )
			{
				JOptionPane.showMessageDialog( this, "Exception occured while connecting: " + ex );
				ex.printStackTrace();
//				exitForm( null );
			}

		}
		

		handleFullscreen();
		
		//
		// Getting here means that connection to a server is established.
		//
		mEngine.requestFocus();
	}


    private final void collectDisplayModes()
    {
        
        DisplayMode [] modes = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayModes();        

        for( int i = 0; i < modes.length; i++ )
        {

            // Nothing with less than 16 bit is acceptable.
//            if ( modes[ i ].getBitDepth() < 16 )
//                continue;
    
			if ( modes[ i ].getWidth() == 800  &&  modes[ i ].getHeight() == 600 )
			{
				if ( mFullscreenMode != null )
				{
					if (	modes[ i ].getRefreshRate() < 100
						&&	( mFullscreenMode.getRefreshRate() < modes[ i ].getRefreshRate() 
							|| mFullscreenMode.getBitDepth() < modes[ i ].getBitDepth() )
							)
					{
						mFullscreenMode = modes[ i ];
					}
				}
				else
					mFullscreenMode = modes[ i ];
			}
		}
    }
	
	
	void handleFullscreen()
	{
		collectDisplayModes();
		
        GraphicsDevice dev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        
        DisplayMode mode = mFullscreenMode;

		if ( null == mode )
			return;
		
        //
        // Tell the logger what we are going to do.
        //
        String desc = mode.getWidth() + "x" + mode.getHeight() + "x" + mode.getBitDepth() + "@" + mode.getRefreshRate();
        Log.logger.info( "Using displaymode " + desc );

        
        if ( mLogin.goFullscreen()  &&  dev.isFullScreenSupported()  /*&&  dev.isDisplayChangeSupported()*/  )
		{
			this.dispose();
			this.setUndecorated( true );
//			this.setIgnoreRepaint( true );

            mDesktopMode = dev.getDisplayMode();
			dev.setFullScreenWindow( this );		
            dev.setDisplayMode( mode );
            
            // Set canvas back to 800x600, bc. with DX, going to fullscreen changed size of window! 
            mEngine.setSize( mode.getWidth(), mode.getHeight() );
		}
//		else
//		{
//            mEngine.setSize( mode.getWidth(), mode.getHeight() );
//            this.getContentPane().add( mEngine );
//			this.pack();
//			this.center();
//            this.show();
//		}

//		this.setCursor( Cursor.getPredefinedCursor( Cursor.CROSSHAIR_CURSOR ) );
		
	}
	
	
	/**
	 * Do my own init stuff.
	 */
	private void initCustom()
	{
		this.getContentPane().add( mEngine, BorderLayout.CENTER );
	}
	
	
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    private void initComponents()//GEN-BEGIN:initComponents
    {

        setTitle("JPilot client - v0.2");
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter()
        {
            public void windowClosing(java.awt.event.WindowEvent evt)
            {
                exitForm(evt);
            }
        });

    }//GEN-END:initComponents
	
	/** Exit the Application */
	private void exitForm(java.awt.event.WindowEvent evt)//GEN-FIRST:event_exitForm
	{
		if ( null != mClt )
			mClt.close();

		if ( null != mServer )
			mServer.close();
		
		System.exit(0);
	}//GEN-LAST:event_exitForm

	
	/**
	 * Helper.
	 */
    private void center()
    {
        // Plonk it on center of screen
        Dimension WindowSize = getSize();
        Dimension ScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
        setBounds( ( ScreenSize.width - WindowSize.width ) / 2,
                ( ScreenSize.height - WindowSize.height ) / 2, WindowSize.width,
                WindowSize.height );
    }

	
	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[])
	{
		new JPilot( args );
	}
	
	
	
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
	
}
