//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//
// Created on 1. Mrz 2003, 18:40
//**********************************************************************************************
package de.hardcode.util;

import javax.vecmath.Quat4f;

/**
 *
 * @author  Herkules
 */
public class QuatUtil
{
    public final static float dot( Quat4f q1, Quat4f q2 ) 
    {
        return q1.x*q2.x + q1.y*q2.y + q1.z*q2.z + q1.w*q2.w;
    }
    
    
    /**
     * Make sure two quats are on the same hemisphere.
     * Modify <code>q1</code> if necessary.
     */
    public static boolean makeClosest( Quat4f q1, Quat4f q2 )
    {
        if ( dot( q1, q2 ) < 0.f )
        {
            q1.negate();
            return true;
        }
        return false;
    }

    
    /** 
     * Perform a robust quaternion slerp.
     */
    public static void slerp( Quat4f q1, Quat4f q2, float t )
    {
        q1.normalize();
        q2.normalize();
        makeClosest( q1, q2 );
        q1.interpolate( q2, t );
        q1.normalize();
    }
    
}
