//**********************************************************************************************
//		(C) Copyright 2002 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//
//	Created on 14. Juli 2002, 16:21
//**********************************************************************************************
package de.hardcode.util;

import java.net.URL;
import java.io.InputStream;

/**
 *
 * @author  Herkules
 */
public class ClassURLProvider implements URLProvider
{	
	private final Class mClass;
	
	/**
	 * Creates a new instance of URLProvider.
	 */
	public ClassURLProvider( Class clazz )
	{
		mClass = clazz;
	}
	
	/**
	 * Creates a new instance of URLProvider.
	 */
	public ClassURLProvider()
	{
		mClass = this.getClass();
	}
	
	
	public URL createURL( String rel )
	{
		return mClass.getResource( rel );
	}
	
	public InputStream createStream( String rel )
	{
		return mClass.getResourceAsStream( rel );
	}

	public static void main( String [] argv ) 
	{
		System.out.println( (new ClassURLProvider()).createURL( "xml/planes.xml" ) );
		System.out.println( (new ClassURLProvider()).createStream( "xml/planes.xml" ) );
	}
	
}
