//**********************************************************************************************
//		(C) Copyright 2002 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//
//	Created on 14. Juli 2002, 16:21
//**********************************************************************************************
package de.hardcode.util;

import java.net.URL;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

/**
 *
 * @author  Herkules
 */
public class BaseDirectoryURLProvider implements URLProvider
{	
	private final String mBasePath;
	private final String mProtocol = "file:";
	
	/**
	 * Creates a new instance of URLProvider.
	 */
	public BaseDirectoryURLProvider( String pathname )
	{
		mBasePath = pathname;
	}
		
	
	public URL createURL( String rel )
	{
		try
		{
			return new URL( mProtocol + mBasePath + rel );
		}
		catch ( MalformedURLException e )
		{
			e.printStackTrace();
		}
		
		return null;
	}

	
	public InputStream createStream( String rel )
	{
		try
		{
			return new FileInputStream( mBasePath + rel );
		}
		catch ( FileNotFoundException e )
		{
			e.printStackTrace();
		}	
		return null;
	}

	public static void main( String [] argv ) 
	{
		System.out.println( (new BaseDirectoryURLProvider( "./data/" )).createURL( "xml/planes.xml" ) );
		System.out.println( (new BaseDirectoryURLProvider( "./data/" )).createStream( "xml/planes.xml" ) );
	}
	
}
