//**********************************************************************************************
//		(C) Copyright 2001 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.hardcode.time;


/**
 * Measure the accuracy of the timer This classes 'measure' method has to be run at highest thread priority!
 */
public class TimerAccuracy
{
	static public long sMinRes = -1;
	static public long sMaxRes = -1;
    
	
	/**
	 * Hide constructor to enforce static use.
	 */
	private TimerAccuracy()
	{	
 	}
	
	/**
	 * Measure the actual resolution of the JVM System timer.
     * @return the best resolution we may expect.
	 */
	public static synchronized final long measure( Clock clk, long timeToMeasure )
	{
		// Max./min. ticker difference
		sMaxRes = 0;
		sMinRes = 999999;

        int savePrio = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority( Thread.MAX_PRIORITY );
        
		// Get current ms ticker
		long ms = clk.getCurrentTime();

		// Calculate time to stop
		long EndMs = ms + timeToMeasure;

        //
		// Loop for the desired time
        //
		while ( ms < EndMs )
		{
			long oldms = ms;
			ms = clk.getCurrentTime();
			long diff = ms - oldms;

			if ( diff > sMaxRes )
				sMaxRes = diff;

			if ( diff > 0 && diff < sMinRes )
				sMinRes = diff;
		}

        Thread.currentThread().setPriority( savePrio );
        
        // Return the best we may expect
		return sMinRes;
        
	}

	public static final long getBestResolution()
	{
		return sMinRes;
	}
	
	public static final long getWorstResolution()
	{
		return sMaxRes;
	}
	
	/**
	 * Make a user presentable string from the result.
	 */
	public static final String getResultAsString()
	{
		return "best timer resolution: " + sMinRes + ", worst timer resolution: " + sMaxRes;
	}

} // TimerAccuracy



