//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.hardcode.time;


/**
 * A thread driving a ticker.
 *
 * @author  Herkules
 */
public class TickingThread extends Thread implements Ticking
{
	private final Clock mClock;
	private final Ticker mTicker;
	private final long mInterval;
	private boolean mDoTick = false;
	
	/**
	 * Creates a new instance of TickingThread
	 */
	public TickingThread( Clock clock, Ticker ticker, long interval )
	{
		mClock		= clock;
		mTicker		= ticker;
		mInterval	= interval;
		this.start();
	}
	
	public Clock getClock()
	{
		return mClock;
	}
	
	public Ticker getTicker()
	{
		return mTicker;
	}
	
	public void startTicking()
	{
		mDoTick = true;
	}
	
	public synchronized void stopTicking()
	{
		mDoTick = false;

		try
		{
			this.wait();
		}
		catch ( InterruptedException irex )
		{
		}
	}
	
	
	/**
	 * Overload Runnable#run().
	 */
	public void run()
	{
		while( true )
		{
			if ( mDoTick )
				getTicker().tick( getClock().getCurrentTime() );
			try
			{
				Thread.sleep( mInterval );
				synchronized( this )
				{
					if ( ! mDoTick )
						this.notify();
				}
			}
			catch ( InterruptedException irex )
			{}
		}
	}
}
