//**********************************************************************************************
//		(C) Copyright 2002 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//
//	Created on 29. April 2002, 22:27
//**********************************************************************************************
package de.hardcode.time;

/**
 * A ticking object as a source for the Ticker.
 *
 * While executing periodically, it should call 
 * <code>getTicker().tick( getClock().getCurrentTime() );</code>.
 *
 * @author  Herkules
 */
public interface Ticking
{
	
	/**
	 * Start ticking.
	 */
	void startTicking();
	
	/**
	 * Stop ticking.
	 */
	void stopTicking();
    
    /**
     * Tickings do need a conjunction with a clock. Here it is.
     */
    Clock getClock();

    /**
     * Tickings do need a conjunction with a Ticker. Here it is.
     */
    Ticker getTicker();

}

