//**********************************************************************************************
//		(C) Copyright 2001 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//
//		Created on 16. November 2001, 23:25
//**********************************************************************************************
package de.hardcode.time;

/**
 * Listen to the ticks of a Clock.
 * @author  Herkules
 */
public interface TickerListener 
{
	/**
	 * Receive a tick from a ticker.
	 * @param ticker The Ticker that caused the tick.
	 */
	public void tick( Ticker ticker );
	
	
	/**
	 * Ticker got resetted.
	 * @param ticker The Ticker that got adjusted.
	 */
	public void reset( Ticker ticker );
}

