//**********************************************************************************************
//		(C) Copyright 2002 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//
// Created on 6. Dezember 2002, 18:01
//**********************************************************************************************
package de.hardcode.time;

import java.util.ArrayList;

/**
 *
 * @author  Herkules
 */
public class Ticker
{
	private         int         mTicks          = 0;
	private         long        mCurrentTickTime;
	private         float       mDeltaT;

    /** 
     * List of listeners interested in my ticks. 
     */
	ArrayList mListeners = new ArrayList();
    
    /**
     * Creates a new instance of Ticker.
     */
    public Ticker()
    {
    }
    
    
	/**
	 * Retrieve current number of ticks.
	 */
	public final int getTicks()
	{
		return mTicks;
	}
	/**
	 * The current time from the start in milliseconds.
	 */
	public final long getTickTime()
	{
		return mCurrentTickTime;
	}

    
    /**
	 * Return the time since last tick.
	 */
	public float getDeltaT()
	{
		return mDeltaT;
	}
	
    
	/**
	 * Reset value for deltaT. If the clock has been suspended for a while,
	 * this call will prevent HUGE values of deltaT.
	 */
	public void reset( Clock clock )
	{
    	mDeltaT = 0.0f;
        mCurrentTickTime = clock.getCurrentTime();

        //
        // Tell all listeners.
        //
        int listenercount = mListeners.size();
        for ( int i = listenercount-1; i >= 0; i-- )
        {
            ((TickerListener)mListeners.get( i )).reset( this );
        }			
	}
	
    
	/**
	 * Add another listener.
	 */
	public void addClockListener( TickerListener lstr )
	{
		mListeners.add( lstr );
	}

    
	/**
	 * Remove listener.
	 */
	public void removeClockListener( TickerListener lstr )
	{
		mListeners.remove( lstr );
	}
	
	
	/**
	 * Ticking callback for the ticking object.
	 */
	public void tick( long ticktime )
	{
		mTicks ++; 
        
        mDeltaT = ticktime - mCurrentTickTime;
        mCurrentTickTime = ticktime;

        //
        // Tell all listeners.
        //
        int listenercount = mListeners.size();
        for ( int i = listenercount-1; i >= 0; i-- )
        {
            ((TickerListener)mListeners.get( i )).tick( this );
        }
	}
    
}
