//**********************************************************************************************
//		(C) Copyright 2002 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//
// Created on 6. Dezember 2002, 21:20
//**********************************************************************************************
package de.hardcode.time;

/**
 *
 * @author  Herkules
 */
public class SystemClock implements Clock
{
	private         long        mBaseMS = 0;
    
    /**
     * Creates a new instance of SystemClock.
     */
    public SystemClock()
    {
        adjust( 0 );
    }
    
    /** 
     * Adjust the clock to a certain value.
     * Calling <code>getCurrentTime()</code> immediately after <code>adjust()</code>
     * should return <code>refvalue</code>.
     */
    public void adjust(long refvalue)
    {        
        mBaseMS = System.currentTimeMillis() - refvalue;
    }
    
    /**
     * The current time from the start in milliseconds.
     */
    public long getCurrentTime()
    {		
        return System.currentTimeMillis() - mBaseMS;
    }
    
}
