//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.hardcode.time;

/**
 *
 * @author  Herkules
 */
public class SmoothedTicker extends Ticker
{
    
    private final float[]   mRemembered = new float[ 5 ];
    private int             mRemIdx = 0;
    private float           mAverage;
    private float           mSmoothedTime;
    
    /**
     * Creates a new instance of SmoothedTicker.
     */
    public SmoothedTicker( float initial )
    {
        for ( int i = 0; i < mRemembered.length; i++ )
            mRemembered[ i ] = initial;
        mAverage = initial;
    }

    private void calcAverage()
    {
        mAverage = 0.0f;
        for ( int i = 0; i < mRemembered.length; i++ )
            mAverage += mRemembered[ i ];
        mAverage /= mRemembered.length;
    }
    
    
    private float filterPeaks( float dt )
    {
        float ratio = dt / mAverage;
        if ( ratio > 2.0  ||  ratio < 0.5 )
        {
//            System.out.println("Peak detected!");
            return mAverage;
        }
        return dt;
    }
    
    
    private void removeGlitch( long ticktime )
    {
        mSmoothedTime += mAverage;
        float glitch = ticktime - mSmoothedTime;
    
        float correct = glitch / 100;

//            for ( int i = 0; i < mRemembered.length; i++ )
//                mRemembered[ i ] -= correct;
        mAverage += correct;
        mSmoothedTime += correct;
        
//        System.out.println( glitch );      
    }
    
    
    /**
	 * Return the time since last tick.
	 */
	public float getDeltaT()
	{
		return mAverage;
	}
    
    
	public void reset( Clock clock )
	{
        mSmoothedTime = clock.getCurrentTime();
        super.reset( clock );
    }
    
    
   	public void tick( long ticktime )
    {
        float dt = ticktime - super.getTickTime();
//        dt = filterPeaks( dt );

        mRemembered[ mRemIdx ++ ] = dt;
        mRemIdx %= mRemembered.length;
    
        calcAverage();
        removeGlitch( ticktime );
        
        super.tick( ticktime );
    }

}
