//**********************************************************************************************
//		(C) Copyright 2002 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//
// Created on 6. Dezember 2002, 21:20
//**********************************************************************************************
package de.hardcode.time;

/**
 *
 * @author  Herkules
 */
public class HiResClock implements Clock
{
	private         long        mBaseMS = 0;
    
    /**
     * Creates a new instance of HiResClock.
     */
    public HiResClock()
    {
        adjust( 0 );
    }
 
    
    /** 
     * Check wether hires timer is available on this installation.
     */
    public final static boolean isAvailable()
    {
        try
        {
            ClassLoader.getSystemClassLoader().loadClass( "com.sun.j3d.utils.timer.J3DTimer" );
			return true;
        }
        catch ( ClassNotFoundException cnfe )
        {
            return false;
        }
    }
    
    /** 
     * Adjust the clock to a certain value.
     * Calling <code>getCurrentTime()</code> immediately after <code>adjust()</code>
     * should return <code>refvalue</code>.
     */
    public void adjust(long refvalue)
    {        
        mBaseMS = getMS() - refvalue;
    }
    
    /**
     * The current time from the start in milliseconds.
     */
    public long getCurrentTime()
    {		
        return getMS() - mBaseMS;
    }
    
    
    /**
     * Internal time retrieval function.
     */
    private final long getMS()
    {
        return com.sun.j3d.utils.timer.J3DTimer.getValue() / 1000000;        
    }
    
}
