//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.hardcode.time;

import java.util.Calendar;

/**
 *
 * @author  Herkules
 */
public class ClockTest
{
	private final Clock mClock;
	
	/**
	 * Creates a new instance of ClockTest
	 */
	public ClockTest( Clock clock )
	{
		mClock = clock;
		test();
	}
	
	
	void test()
	{
		long maxdiff = 0;
		
		mClock.adjust( Calendar.getInstance().getTimeInMillis() );  
		while ( true )
		{
			long realtime = Calendar.getInstance().getTimeInMillis(); 
			long clcktime = mClock.getCurrentTime();
			
			long diff = clcktime - realtime;
			long absdiff = Math.abs( diff ); 
			if ( absdiff > maxdiff )
			{
				maxdiff = absdiff;
				System.out.println( "Time shifted: " + diff );
			}
		}
	}
	
	
	public static void main( String [] args )
	{
		new ClockTest( new SystemClock() );
	}
}
