/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.util;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PRoot;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;

public class PUtil {
    public static Iterator NULL_ITERATOR = Collections.EMPTY_LIST.iterator();
    public static long DEFAULT_ACTIVITY_STEP_RATE = 20L;
    public static int ACTIVITY_SCHEDULER_FRAME_DELAY = 10;
    public static OutputStream NULL_OUTPUT_STREAM = new OutputStream(){

        public void close() {
        }

        public void flush() {
        }

        public void write(byte[] b) {
        }

        public void write(byte[] b, int off, int len) {
        }

        public void write(int b) {
        }
    };

    public static PCamera createBasicScenegraph() {
        PRoot r = new PRoot();
        PLayer l = new PLayer();
        PCamera c = new PCamera();
        r.addChild(c);
        r.addChild(l);
        c.addLayer(l);
        return c;
    }

    public static void writeStroke(Stroke aStroke, ObjectOutputStream out) throws IOException {
        if (aStroke instanceof Serializable) {
            out.writeBoolean(true);
            out.writeBoolean(true);
            out.writeObject(aStroke);
        } else if (aStroke instanceof BasicStroke) {
            out.writeBoolean(true);
            out.writeBoolean(false);
            BasicStroke s = (BasicStroke)aStroke;
            float[] dash = s.getDashArray();
            if (dash == null) {
                out.write(0);
            } else {
                out.write(dash.length);
                for (int i = 0; i < dash.length; ++i) {
                    out.writeFloat(dash[i]);
                }
            }
            out.writeFloat(s.getLineWidth());
            out.writeInt(s.getEndCap());
            out.writeInt(s.getLineJoin());
            out.writeFloat(s.getMiterLimit());
            out.writeFloat(s.getDashPhase());
        } else {
            out.writeBoolean(false);
        }
    }

    public static Stroke readStroke(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean wroteStroke = in.readBoolean();
        if (wroteStroke) {
            boolean serializedStroke = in.readBoolean();
            if (serializedStroke) {
                return (Stroke)in.readObject();
            }
            float[] dash = null;
            int dashLength = in.read();
            if (dashLength != 0) {
                dash = new float[dashLength];
                for (int i = 0; i < dashLength; ++i) {
                    dash[i] = in.readFloat();
                }
            }
            float lineWidth = in.readFloat();
            int endCap = in.readInt();
            int lineJoin = in.readInt();
            float miterLimit = in.readFloat();
            float dashPhase = in.readFloat();
            return new BasicStroke(lineWidth, endCap, lineJoin, miterLimit, dash, dashPhase);
        }
        return null;
    }
}

