/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.examples;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.PFrame;
import java.awt.BasicStroke;
import java.awt.geom.Point2D;

public class SquiggleExample
extends PFrame {
    private PLayer layer;

    public SquiggleExample() {
    }

    public SquiggleExample(PCanvas aCanvas) {
        super(false, aCanvas);
    }

    public void initialize() {
        super.initialize();
        PBasicInputEventHandler squiggleEventHandler = this.createSquiggleEventHandler();
        squiggleEventHandler.setEventFilter(new PInputEventFilter(16));
        this.getCanvas().removeInputEventListener(this.getCanvas().getPanEventHandler());
        this.getCanvas().addInputEventListener(squiggleEventHandler);
        this.layer = this.getCanvas().getLayer();
    }

    public PBasicInputEventHandler createSquiggleEventHandler() {
        return new PDragSequenceEventHandler(){
            protected PPath squiggle;

            public void startDrag(PInputEvent e) {
                super.startDrag(e);
                Point2D p = e.getPosition();
                this.squiggle = new PPath();
                this.squiggle.moveTo((float)p.getX(), (float)p.getY());
                this.squiggle.setStroke(new BasicStroke((float)(1.0 / e.getCamera().getViewScale())));
                SquiggleExample.this.layer.addChild(this.squiggle);
            }

            public void drag(PInputEvent e) {
                super.drag(e);
                this.updateSquiggle(e);
            }

            public void endDrag(PInputEvent e) {
                super.endDrag(e);
                this.updateSquiggle(e);
                this.squiggle = null;
            }

            public void updateSquiggle(PInputEvent aEvent) {
                Point2D p = aEvent.getPosition();
                this.squiggle.lineTo((float)p.getX(), (float)p.getY());
            }
        };
    }

    public static void main(String[] args) {
        new SquiggleExample();
    }
}

