/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.examples;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.PFrame;
import edu.umd.cs.piccolox.swing.PDefaultScrollDirector;
import edu.umd.cs.piccolox.swing.PScrollDirector;
import edu.umd.cs.piccolox.swing.PScrollPane;
import edu.umd.cs.piccolox.swing.PViewport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class ScrollingExample
extends PFrame {
    public void initialize() {
        PCanvas canvas = this.getCanvas();
        final PScrollPane scrollPane = new PScrollPane(canvas);
        this.getContentPane().add(scrollPane);
        final PViewport viewport = (PViewport)scrollPane.getViewport();
        final PScrollDirector windowSD = viewport.getScrollDirector();
        final DocumentScrollDirector documentSD = new DocumentScrollDirector();
        for (int x = 0; x < 20; ++x) {
            for (int y = 0; y < 20; ++y) {
                PPath path;
                if ((x + y) % 2 == 0) {
                    path = PPath.createRectangle(50 * x, 50 * y, 40.0f, 40.0f);
                    path.setPaint(Color.blue);
                    path.setStrokePaint(Color.black);
                    canvas.getLayer().addChild(path);
                    continue;
                }
                if ((x + y) % 2 != 1) continue;
                path = PPath.createEllipse(50 * x, 50 * y, 40.0f, 40.0f);
                path.setPaint(Color.blue);
                path.setStrokePaint(Color.black);
                canvas.getLayer().addChild(path);
            }
        }
        JToolBar toolBar = new JToolBar();
        JToggleButton window = new JToggleButton("Window Scrolling");
        JToggleButton document = new JToggleButton("Document Scrolling");
        ButtonGroup bg = new ButtonGroup();
        bg.add(window);
        bg.add(document);
        toolBar.add(window);
        toolBar.add(document);
        toolBar.setFloatable(false);
        window.setSelected(true);
        window.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                viewport.setScrollDirector(windowSD);
                viewport.fireStateChanged();
                scrollPane.revalidate();
            }
        });
        document.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                viewport.setScrollDirector(documentSD);
                viewport.fireStateChanged();
                scrollPane.revalidate();
            }
        });
        this.getContentPane().add((Component)toolBar, "North");
        this.getContentPane().validate();
    }

    public static void main(String[] args) {
        new ScrollingExample();
    }

    public class DocumentScrollDirector
    extends PDefaultScrollDirector {
        public Point getViewPosition(Rectangle2D viewBounds) {
            Point pos = new Point();
            if (this.camera != null) {
                PBounds layerBounds = new PBounds();
                List layers = this.camera.getLayersReference();
                Iterator i = layers.iterator();
                while (i.hasNext()) {
                    PLayer layer = (PLayer)i.next();
                    layerBounds.add(layer.getFullBoundsReference());
                }
                this.camera.viewToLocal(layerBounds);
                layerBounds.add(viewBounds);
                pos.setLocation((int)(layerBounds.getWidth() - (viewBounds.getX() + viewBounds.getWidth() - layerBounds.getX()) + 0.5), (int)(layerBounds.getHeight() - (viewBounds.getY() + viewBounds.getHeight() - layerBounds.getY()) + 0.5));
            }
            return pos;
        }

        public void setViewPosition(double x, double y) {
            if (this.camera != null && !this.scrollInProgress) {
                this.scrollInProgress = true;
                PBounds layerBounds = new PBounds();
                List layers = this.camera.getLayersReference();
                Iterator i = layers.iterator();
                while (i.hasNext()) {
                    PLayer layer = (PLayer)i.next();
                    layerBounds.add(layer.getFullBoundsReference());
                }
                PAffineTransform at = this.camera.getViewTransform();
                at.transform(layerBounds, layerBounds);
                PBounds viewBounds = this.camera.getBoundsReference();
                layerBounds.add(viewBounds);
                Point2D.Double newPoint = new Point2D.Double(layerBounds.getX() + layerBounds.getWidth() - (x + viewBounds.getWidth()), layerBounds.getY() + layerBounds.getHeight() - (y + viewBounds.getHeight()));
                this.camera.localToView(newPoint);
                double newX = -(at.getScaleX() * ((Point2D)newPoint).getX() + at.getShearX() * ((Point2D)newPoint).getY());
                double newY = -(at.getShearY() * ((Point2D)newPoint).getX() + at.getScaleY() * ((Point2D)newPoint).getY());
                at.setTransform(at.getScaleX(), at.getShearY(), at.getShearX(), at.getScaleY(), newX, newY);
                this.camera.setViewTransform(at);
                this.scrollInProgress = false;
            }
        }
    }
}

