/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.examples;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolox.PFrame;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.util.ArrayList;

public class PiccoloPresentation
extends PFrame {
    protected PNode slideBar;
    protected PNode currentSlide;
    protected PBasicInputEventHandler eventHandler;
    protected ArrayList slides = new ArrayList();

    public void initialize() {
        this.setFullScreenMode(true);
        this.loadSlides();
        this.eventHandler = new PBasicInputEventHandler(){

            public void keyReleased(PInputEvent event) {
                int newIndex;
                if (event.getKeyCode() == 32 && (newIndex = PiccoloPresentation.this.slides.indexOf(PiccoloPresentation.this.currentSlide) + 1) < PiccoloPresentation.this.slides.size()) {
                    PiccoloPresentation.this.goToSlide((PNode)PiccoloPresentation.this.slides.get(newIndex));
                }
            }

            public void mouseReleased(PInputEvent event) {
                PNode picked = event.getPickedNode();
                if (picked.getParent() == PiccoloPresentation.this.slideBar) {
                    picked.moveToFront();
                    if (picked.getScale() == 1.0) {
                        PiccoloPresentation.this.goToSlide(null);
                    } else {
                        PiccoloPresentation.this.goToSlide(picked);
                    }
                }
            }
        };
        this.getCanvas().requestFocus();
        this.getCanvas().addInputEventListener(this.eventHandler);
        this.getCanvas().getRoot().getDefaultInputManager().setKeyboardFocus(this.eventHandler);
        this.getCanvas().removeInputEventListener(this.getCanvas().getZoomEventHandler());
        this.getCanvas().removeInputEventListener(this.getCanvas().getPanEventHandler());
    }

    public void goToSlide(PNode slide) {
        if (this.currentSlide != null) {
            this.currentSlide.animateToTransform((AffineTransform)this.currentSlide.getClientProperty("small"), 1000L);
        }
        this.currentSlide = slide;
        if (this.currentSlide != null) {
            this.currentSlide.moveToFront();
            this.currentSlide.animateToTransform((AffineTransform)this.currentSlide.getClientProperty("large"), 1000L);
        }
    }

    public void loadSlides() {
        this.slideBar = new PNode();
        this.slideBar.setPaint(Color.DARK_GRAY);
        this.slideBar.setBounds(0.0, 0.0, this.getCanvas().getWidth(), 100.0);
        this.slideBar.setOffset(0.0, this.getCanvas().getHeight() - 100);
        this.getCanvas().getLayer().addChild(this.slideBar);
        File[] slideFiles = new File("slides").listFiles();
        for (int i = 0; i < slideFiles.length; ++i) {
            PImage slide = new PImage(slideFiles[i].getPath(), false);
            if (slide.getHeight() != (double)(this.getHeight() - 100)) {
                slide = new PImage(slide.toImage(this.getWidth(), this.getHeight() - 100, null), true);
            }
            slide.offset(((double)this.getWidth() - slide.getWidth()) / 2.0, -(this.getHeight() - 100));
            slide.addClientProperty("large", slide.getTransform());
            slide.setTransform(new AffineTransform());
            slide.scale(80.0 / slide.getHeight());
            slide.offset((double)i * (slide.getFullBoundsReference().getWidth() + 10.0) + 10.0, 10.0);
            slide.addClientProperty("small", slide.getTransform());
            this.slideBar.addChild(slide);
            this.slides.add(slide);
        }
        this.goToSlide((PNode)this.slides.get(0));
    }

    public static void main(String[] argv) {
        new PiccoloPresentation();
    }
}

