/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.examples;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.PFrame;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;

public class NodeExample
extends PFrame {
    boolean fIsPressed = false;

    public NodeExample() {
    }

    public NodeExample(PCanvas aCanvas) {
        super(false, aCanvas);
    }

    public void initialize() {
        this.nodeDemo();
        this.createNodeUsingExistingClasses();
        this.subclassExistingClasses();
        this.composeOtherNodes();
        this.createCustomNode();
        this.getCanvas().removeInputEventListener(this.getCanvas().getPanEventHandler());
        this.getCanvas().addInputEventListener(new PDragEventHandler());
    }

    public void nodeDemo() {
        PLayer layer = this.getCanvas().getLayer();
        PPath aNode = PPath.createRectangle(0.0f, 0.0f, 100.0f, 80.0f);
        layer.addChild(aNode);
        aNode.setPaint(Color.red);
        aNode.addChild(PPath.createRectangle(0.0f, 0.0f, 100.0f, 80.0f));
        ((PNode)aNode).setBounds(-10.0, -10.0, 200.0, 110.0);
        aNode.translate(100.0, 100.0);
        aNode.scale(1.5);
        aNode.rotate(45.0);
        aNode.setTransparency(0.75f);
        PNode aCopy = (PNode)aNode.clone();
        aNode.setChildrenPickable(false);
        aNode.setPaint(Color.GREEN);
        aNode.setTransparency(1.0f);
        layer.addChild(aCopy);
        aCopy.setOffset(0.0, 0.0);
        aCopy.rotate(-45.0);
    }

    public void createNodeUsingExistingClasses() {
        PLayer layer = this.getCanvas().getLayer();
        layer.addChild(PPath.createEllipse(0.0f, 0.0f, 100.0f, 100.0f));
        layer.addChild(PPath.createRectangle(0.0f, 100.0f, 100.0f, 100.0f));
        layer.addChild(new PText("Hello World"));
        layer.addChild(new PImage(layer.toImage(300, 300, Color.YELLOW), true));
    }

    public void subclassExistingClasses() {
        final PPath n = new PPath(new Ellipse2D.Float(0.0f, 0.0f, 100.0f, 80.0f)){

            public void paint(PPaintContext aPaintContext) {
                if (NodeExample.this.fIsPressed) {
                    Graphics2D g2 = aPaintContext.getGraphics();
                    g2.setPaint(this.getPaint());
                    g2.fill(this.getBoundsReference());
                } else {
                    super.paint(aPaintContext);
                }
            }
        };
        n.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent aEvent) {
                super.mousePressed(aEvent);
                NodeExample.this.fIsPressed = true;
                n.invalidatePaint();
            }

            public void mouseReleased(PInputEvent aEvent) {
                super.mousePressed(aEvent);
                NodeExample.this.fIsPressed = false;
                n.invalidatePaint();
            }
        });
        n.setPaint(Color.ORANGE);
        this.getCanvas().getLayer().addChild(n);
    }

    public void composeOtherNodes() {
        PPath myCompositeFace = PPath.createRectangle(0.0f, 0.0f, 100.0f, 80.0f);
        PPath eye1 = PPath.createEllipse(0.0f, 0.0f, 20.0f, 20.0f);
        eye1.setPaint(Color.YELLOW);
        PNode eye2 = (PNode)eye1.clone();
        PPath mouth = PPath.createRectangle(0.0f, 0.0f, 40.0f, 20.0f);
        mouth.setPaint(Color.BLACK);
        myCompositeFace.addChild(eye1);
        myCompositeFace.addChild(eye2);
        myCompositeFace.addChild(mouth);
        myCompositeFace.setChildrenPickable(false);
        eye2.translate(25.0, 0.0);
        mouth.translate(0.0, 30.0);
        PBounds b = myCompositeFace.getUnionOfChildrenBounds(null);
        myCompositeFace.setBounds(b.inset(-5.0, -5.0));
        myCompositeFace.scale(1.5);
        this.getCanvas().getLayer().addChild(myCompositeFace);
    }

    public void createCustomNode() {
        PNode n = new PNode(){

            public void paint(PPaintContext aPaintContext) {
                double bx = this.getX();
                double by = this.getY();
                double rightBorder = bx + this.getWidth();
                double bottomBorder = by + this.getHeight();
                Line2D.Double line = new Line2D.Double();
                Graphics2D g2 = aPaintContext.getGraphics();
                g2.setStroke(new BasicStroke(0.0f));
                g2.setPaint(this.getPaint());
                for (double x = bx; x < rightBorder; x += 5.0) {
                    ((Line2D)line).setLine(x, by, x, bottomBorder);
                    g2.draw(line);
                }
                for (double y = by; y < bottomBorder; y += 5.0) {
                    ((Line2D)line).setLine(bx, y, rightBorder, y);
                    g2.draw(line);
                }
            }
        };
        n.setBounds(0.0, 0.0, 100.0, 80.0);
        n.setPaint(Color.black);
        this.getCanvas().getLayer().addChild(n);
    }

    public static void main(String[] args) {
        new NodeExample();
    }
}

