/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.examples;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.PFrame;
import java.awt.Color;

public class KeyEventFocusExample
extends PFrame {
    public KeyEventFocusExample() {
    }

    public KeyEventFocusExample(PCanvas aCanvas) {
        super(false, aCanvas);
    }

    public void initialize() {
        PCanvas canvas = this.getCanvas();
        PPath nodeGreen = PPath.createRectangle(0.0f, 0.0f, 100.0f, 100.0f);
        PPath nodeRed = PPath.createRectangle(0.0f, 0.0f, 100.0f, 100.0f);
        nodeRed.translate(200.0, 0.0);
        nodeGreen.setPaint(Color.green);
        nodeRed.setPaint(Color.red);
        canvas.getLayer().addChild(nodeGreen);
        canvas.getLayer().addChild(nodeRed);
        nodeGreen.addInputEventListener(new PBasicInputEventHandler(){

            public void keyPressed(PInputEvent event) {
                System.out.println("green keypressed");
            }

            public void mousePressed(PInputEvent event) {
                event.getInputManager().setKeyboardFocus(event.getPath());
                System.out.println("green mousepressed");
            }

            public void keyboardFocusGained(PInputEvent event) {
                System.out.println("green focus gained");
            }

            public void keyboardFocusLost(PInputEvent event) {
                System.out.println("green focus lost");
            }
        });
        nodeRed.addInputEventListener(new PBasicInputEventHandler(){

            public void keyPressed(PInputEvent event) {
                System.out.println("red keypressed");
            }

            public void mousePressed(PInputEvent event) {
                event.getInputManager().setKeyboardFocus(event.getPath());
                System.out.println("red mousepressed");
            }

            public void keyboardFocusGained(PInputEvent event) {
                System.out.println("red focus gained");
            }

            public void keyboardFocusLost(PInputEvent event) {
                System.out.println("red focus lost");
            }
        });
    }

    public static void main(String[] args) {
        new KeyEventFocusExample();
    }
}

