/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.examples;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.PFrame;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class GridExample
extends PFrame {
    protected static Line2D gridLine = new Line2D.Double();
    protected static Stroke gridStroke = new BasicStroke(1.0f);
    protected static Color gridPaint = Color.BLACK;
    protected static double gridSpacing = 20.0;

    public void initialize() {
        PRoot root = this.getCanvas().getRoot();
        final PCamera camera = this.getCanvas().getCamera();
        final PLayer gridLayer = new PLayer(){

            protected void paint(PPaintContext paintContext) {
                double bx = this.getX() - this.getX() % gridSpacing - gridSpacing;
                double by = this.getY() - this.getY() % gridSpacing - gridSpacing;
                double rightBorder = this.getX() + this.getWidth() + gridSpacing;
                double bottomBorder = this.getY() + this.getHeight() + gridSpacing;
                Graphics2D g2 = paintContext.getGraphics();
                Rectangle2D clip = paintContext.getLocalClip();
                g2.setStroke(gridStroke);
                g2.setPaint(gridPaint);
                for (double x = bx; x < rightBorder; x += gridSpacing) {
                    gridLine.setLine(x, by, x, bottomBorder);
                    if (!clip.intersectsLine(gridLine)) continue;
                    g2.draw(gridLine);
                }
                for (double y = by; y < bottomBorder; y += gridSpacing) {
                    gridLine.setLine(bx, y, rightBorder, y);
                    if (!clip.intersectsLine(gridLine)) continue;
                    g2.draw(gridLine);
                }
            }
        };
        root.removeChild(camera.getLayer(0));
        camera.removeLayer(0);
        root.addChild(gridLayer);
        camera.addLayer(gridLayer);
        camera.addPropertyChangeListener("bounds", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                gridLayer.setBounds(camera.getViewBounds());
            }
        });
        camera.addPropertyChangeListener("viewTransform", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                gridLayer.setBounds(camera.getViewBounds());
            }
        });
        gridLayer.setBounds(camera.getViewBounds());
        PNode n = new PNode();
        n.setPaint(Color.BLUE);
        n.setBounds(0.0, 0.0, 100.0, 80.0);
        this.getCanvas().getLayer().addChild(n);
        this.getCanvas().removeInputEventListener(this.getCanvas().getPanEventHandler());
        this.getCanvas().addInputEventListener(new PDragSequenceEventHandler(){
            protected PNode draggedNode;
            protected Point2D nodeStartPosition;

            protected boolean shouldStartDragInteraction(PInputEvent event) {
                if (super.shouldStartDragInteraction(event)) {
                    return event.getPickedNode() != event.getTopCamera() && !(event.getPickedNode() instanceof PLayer);
                }
                return false;
            }

            protected void startDrag(PInputEvent event) {
                super.startDrag(event);
                this.draggedNode = event.getPickedNode();
                this.draggedNode.moveToFront();
                this.nodeStartPosition = this.draggedNode.getOffset();
            }

            protected void drag(PInputEvent event) {
                super.drag(event);
                Point2D start = GridExample.this.getCanvas().getCamera().localToView((Point2D)this.getMousePressedCanvasPoint().clone());
                Point2D current = event.getPositionRelativeTo(GridExample.this.getCanvas().getLayer());
                Point2D.Double dest = new Point2D.Double();
                ((Point2D)dest).setLocation(this.nodeStartPosition.getX() + (current.getX() - start.getX()), this.nodeStartPosition.getY() + (current.getY() - start.getY()));
                ((Point2D)dest).setLocation(((Point2D)dest).getX() - ((Point2D)dest).getX() % gridSpacing, ((Point2D)dest).getY() - ((Point2D)dest).getY() % gridSpacing);
                this.draggedNode.setOffset(((Point2D)dest).getX(), ((Point2D)dest).getY());
            }
        });
    }

    public static void main(String[] args) {
        new GridExample();
    }
}

