/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.examples;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.PFrame;
import java.awt.BasicStroke;
import java.awt.geom.Point2D;

public class EventHandlerExample
extends PFrame {
    public EventHandlerExample() {
    }

    public EventHandlerExample(PCanvas aCanvas) {
        super(false, aCanvas);
    }

    public void initialize() {
        super.initialize();
        PBasicInputEventHandler rectEventHandler = this.createRectangleEventHandler();
        rectEventHandler.setEventFilter(new PInputEventFilter(16));
        this.getCanvas().removeInputEventListener(this.getCanvas().getPanEventHandler());
        this.getCanvas().addInputEventListener(rectEventHandler);
    }

    public PBasicInputEventHandler createRectangleEventHandler() {
        return new PBasicInputEventHandler(){
            protected PPath rectangle;
            protected Point2D pressPoint;
            protected Point2D dragPoint;

            public void mousePressed(PInputEvent e) {
                super.mousePressed(e);
                PLayer layer = EventHandlerExample.this.getCanvas().getLayer();
                this.dragPoint = this.pressPoint = e.getPosition();
                this.rectangle = new PPath();
                this.rectangle.setStroke(new BasicStroke((float)(1.0 / e.getCamera().getViewScale())));
                layer.addChild(this.rectangle);
                this.updateRectangle();
            }

            public void mouseDragged(PInputEvent e) {
                super.mouseDragged(e);
                this.dragPoint = e.getPosition();
                this.updateRectangle();
            }

            public void mouseReleased(PInputEvent e) {
                super.mouseReleased(e);
                this.updateRectangle();
                this.rectangle = null;
            }

            public void updateRectangle() {
                PBounds b = new PBounds();
                b.add(this.pressPoint);
                b.add(this.dragPoint);
                this.rectangle.setPathTo(b);
            }
        };
    }

    public static void main(String[] args) {
        new EventHandlerExample();
    }
}

