/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.examples;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.PFrame;
import edu.umd.cs.piccolox.util.PFixedWidthStroke;
import java.awt.Color;
import java.util.Iterator;
import java.util.Random;

public class DynamicExample
extends PFrame {
    public DynamicExample() {
    }

    public DynamicExample(PCanvas aCanvas) {
        super(false, aCanvas);
    }

    public void initialize() {
        PLayer layer = this.getCanvas().getLayer();
        PRoot root = this.getCanvas().getRoot();
        Random r = new Random();
        for (int i = 0; i < 1000; ++i) {
            PPath n = PPath.createRectangle(0.0f, 0.0f, 100.0f, 80.0f);
            n.translate(10000.0f * r.nextFloat(), 10000.0f * r.nextFloat());
            n.setPaint(new Color(r.nextFloat(), r.nextFloat(), r.nextFloat()));
            layer.addChild(n);
        }
        this.getCanvas().getCamera().animateViewToCenterBounds(layer.getGlobalFullBounds(), true, 0L);
        PActivity a = new PActivity(-1L, 20L){

            public void activityStep(long currentTime) {
                super.activityStep(currentTime);
                DynamicExample.this.rotateNodes();
            }
        };
        root.addActivity(a);
        PPath p = new PPath();
        p.moveTo(0.0f, 0.0f);
        p.lineTo(0.0f, 1000.0f);
        p.setStroke(new PFixedWidthStroke(5.0f));
    }

    public void rotateNodes() {
        Iterator i = this.getCanvas().getLayer().getChildrenReference().iterator();
        while (i.hasNext()) {
            PNode each = (PNode)i.next();
            each.rotate(Math.toRadians(2.0));
        }
    }

    public static void main(String[] args) {
        new DynamicExample();
    }
}

