/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.examples;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.PFrame;
import edu.umd.cs.piccolox.handles.PHandle;
import edu.umd.cs.piccolox.util.PLocator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class AngleNodeExample
extends PFrame {
    public void initialize() {
        PCanvas c = this.getCanvas();
        PLayer l = c.getLayer();
        l.addChild(new AngleNode());
    }

    public static void main(String[] args) {
        new AngleNodeExample();
    }

    public static class AngleNode
    extends PNode {
        protected Point2D.Double pointOne = new Point2D.Double(100.0, 0.0);
        protected Point2D.Double pointTwo = new Point2D.Double(0.0, 100.0);
        protected Stroke stroke = new BasicStroke(1.0f, 1, 1);

        public AngleNode() {
            this.setPaint(Color.BLACK);
            this.updateBounds();
            this.addHandles();
        }

        public void addHandles() {
            PLocator l = new PLocator(this){
                private final /* synthetic */ AngleNode this$0;
                {
                    this.this$0 = this$0;
                }

                public double locateX() {
                    return this.this$0.pointOne.getX();
                }

                public double locateY() {
                    return this.this$0.pointOne.getY();
                }
            };
            PHandle h = new PHandle(this, l){
                private final /* synthetic */ AngleNode this$0;
                {
                    this.this$0 = this$0;
                    super(x0);
                }

                public void dragHandle(PDimension aLocalDimension, PInputEvent aEvent) {
                    this.localToParent(aLocalDimension);
                    this.this$0.pointOne.setLocation(this.this$0.pointOne.getX() + aLocalDimension.getWidth(), this.this$0.pointOne.getY() + aLocalDimension.getHeight());
                    this.this$0.updateBounds();
                    this.relocateHandle();
                }
            };
            this.addChild(h);
            l = new PLocator(this){
                private final /* synthetic */ AngleNode this$0;
                {
                    this.this$0 = this$0;
                }

                public double locateX() {
                    return this.this$0.pointTwo.getX();
                }

                public double locateY() {
                    return this.this$0.pointTwo.getY();
                }
            };
            h = new PHandle(this, l){
                private final /* synthetic */ AngleNode this$0;
                {
                    this.this$0 = this$0;
                    super(x0);
                }

                public void dragHandle(PDimension aLocalDimension, PInputEvent aEvent) {
                    this.localToParent(aLocalDimension);
                    this.this$0.pointTwo.setLocation(this.this$0.pointTwo.getX() + aLocalDimension.getWidth(), this.this$0.pointTwo.getY() + aLocalDimension.getHeight());
                    this.this$0.updateBounds();
                    this.relocateHandle();
                }
            };
            this.addChild(h);
        }

        protected void paint(PPaintContext paintContext) {
            Graphics2D g2 = paintContext.getGraphics();
            g2.setStroke(this.stroke);
            g2.setPaint(this.getPaint());
            g2.draw(this.getAnglePath());
        }

        protected void updateBounds() {
            GeneralPath p = this.getAnglePath();
            Rectangle2D b = this.stroke.createStrokedShape(p).getBounds2D();
            super.setBounds(b.getX(), b.getY(), b.getWidth(), b.getHeight());
        }

        public GeneralPath getAnglePath() {
            GeneralPath p = new GeneralPath();
            p.moveTo((float)this.pointOne.getX(), (float)this.pointOne.getY());
            p.lineTo(0.0f, 0.0f);
            p.lineTo((float)this.pointTwo.getX(), (float)this.pointTwo.getY());
            return p;
        }

        public boolean setBounds(double x, double y, double width, double height) {
            return false;
        }
    }
}

