/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.examples;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.activities.PInterpolatingActivity;
import edu.umd.cs.piccolo.activities.PTransformActivity;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.PFrame;
import java.awt.Color;

public class ActivityExample
extends PFrame {
    public ActivityExample() {
    }

    public ActivityExample(PCanvas aCanvas) {
        super(false, aCanvas);
    }

    public void initialize() {
        long currentTime = System.currentTimeMillis();
        final PPath aNode = PPath.createRectangle(0.0f, 0.0f, 100.0f, 80.0f);
        PLayer layer = this.getCanvas().getLayer();
        layer.addChild(aNode);
        aNode.setOffset(200.0, 200.0);
        PActivity flash = new PActivity(-1L, 500L, currentTime + 5000L){
            boolean fRed;
            {
                super(x0, x1, x2);
                this.fRed = true;
            }

            protected void activityStep(long elapsedTime) {
                super.activityStep(elapsedTime);
                if (this.fRed) {
                    aNode.setPaint(Color.red);
                } else {
                    aNode.setPaint(Color.green);
                }
                this.fRed = !this.fRed;
            }
        };
        this.getCanvas().getRoot().addActivity(flash);
        PTransformActivity a1 = aNode.animateToPositionScaleRotation(0.0, 0.0, 0.5, 0.0, 5000L);
        PTransformActivity a2 = aNode.animateToPositionScaleRotation(100.0, 0.0, 1.5, Math.toRadians(110.0), 5000L);
        PTransformActivity a3 = aNode.animateToPositionScaleRotation(200.0, 100.0, 1.0, 0.0, 5000L);
        PInterpolatingActivity a4 = aNode.animateToTransparency(0.25f, 3000L);
        a1.setStartTime(currentTime);
        a2.startAfter(a1);
        a3.startAfter(a2);
        a4.startAfter(a3);
    }

    public static void main(String[] args) {
        new ActivityExample();
    }
}

