/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.event;

import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PUtil;
import java.awt.geom.Point2D;

public abstract class PDragSequenceEventHandler
extends PBasicInputEventHandler {
    private double minDragStartDistance = 0.0;
    private transient boolean isDragging = false;
    private transient Point2D mousePressedCanvasPoint;
    private transient PActivity dragActivity;
    private transient PInputEvent dragEvent;
    private transient int sequenceInitiatedButton = 0;

    public boolean isDragging() {
        return this.isDragging;
    }

    public void setIsDragging(boolean isDragging) {
        this.isDragging = isDragging;
    }

    public double getMinDragStartDistance() {
        return this.minDragStartDistance;
    }

    public void setMinDragStartDistance(double minDistance) {
        this.minDragStartDistance = minDistance;
    }

    public Point2D getMousePressedCanvasPoint() {
        if (this.mousePressedCanvasPoint == null) {
            this.mousePressedCanvasPoint = new Point2D.Double();
        }
        return this.mousePressedCanvasPoint;
    }

    protected void startDrag(PInputEvent e) {
        this.dragEvent = e;
        this.startDragActivity(e);
        this.setIsDragging(true);
        e.getComponent().setInteracting(true);
    }

    protected void drag(PInputEvent e) {
        this.dragEvent = e;
    }

    protected void endDrag(PInputEvent e) {
        this.stopDragActivity(e);
        this.dragEvent = null;
        e.getComponent().setInteracting(false);
        this.setIsDragging(false);
    }

    protected boolean shouldStartDragInteraction(PInputEvent e) {
        return this.getMousePressedCanvasPoint().distance(e.getCanvasPosition()) >= this.getMinDragStartDistance();
    }

    protected void startDragActivity(PInputEvent aEvent) {
        this.dragActivity = new PActivity(-1L, PUtil.DEFAULT_ACTIVITY_STEP_RATE);
        this.dragActivity.setDelegate(new PActivity.PActivityDelegate(){

            public void activityStarted(PActivity activity) {
                PDragSequenceEventHandler.this.dragActivityFirstStep(PDragSequenceEventHandler.this.dragEvent);
            }

            public void activityStepped(PActivity activity) {
                PDragSequenceEventHandler.this.dragActivityStep(PDragSequenceEventHandler.this.dragEvent);
            }

            public void activityFinished(PActivity activity) {
                PDragSequenceEventHandler.this.dragActivityFinalStep(PDragSequenceEventHandler.this.dragEvent);
            }
        });
        aEvent.getCamera().getRoot().addActivity(this.dragActivity);
    }

    protected void stopDragActivity(PInputEvent aEvent) {
        this.dragActivity.terminate();
        this.dragActivity = null;
    }

    protected void dragActivityFirstStep(PInputEvent aEvent) {
    }

    protected void dragActivityStep(PInputEvent aEvent) {
    }

    protected void dragActivityFinalStep(PInputEvent aEvent) {
    }

    public void mousePressed(PInputEvent e) {
        super.mousePressed(e);
        if (this.sequenceInitiatedButton != 0) {
            return;
        }
        this.sequenceInitiatedButton = e.getButton();
        this.getMousePressedCanvasPoint().setLocation(e.getCanvasPosition());
        if (!this.isDragging() && this.shouldStartDragInteraction(e)) {
            this.startDrag(e);
        }
    }

    public void mouseDragged(PInputEvent e) {
        super.mouseDragged(e);
        if (this.sequenceInitiatedButton != 0) {
            if (!this.isDragging()) {
                if (this.shouldStartDragInteraction(e)) {
                    this.startDrag(e);
                }
                return;
            }
            this.drag(e);
        }
    }

    public void mouseReleased(PInputEvent e) {
        super.mouseReleased(e);
        if (this.sequenceInitiatedButton == e.getButton()) {
            if (this.isDragging()) {
                this.endDrag(e);
            }
            this.sequenceInitiatedButton = 0;
        }
    }

    protected String paramString() {
        StringBuffer result = new StringBuffer();
        result.append("minDragStartDistance=" + this.minDragStartDistance);
        result.append(",mousePressedCanvasPoint=" + (this.mousePressedCanvasPoint == null ? "null" : this.mousePressedCanvasPoint.toString()));
        result.append(",sequenceInitiatedButton=" + this.sequenceInitiatedButton);
        if (this.isDragging) {
            result.append(",dragging");
        }
        result.append(',');
        result.append(super.paramString());
        return result.toString();
    }
}

