/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PPickPath;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

public class PInputManager
extends PBasicInputEventHandler
implements PRoot.InputSource {
    private static Point2D lastCanvasPosition;
    private static Point2D currentCanvasPosition;
    private InputEvent nextInput;
    private int nextType;
    private PCamera nextInputSource;
    private PPickPath mouseFocus;
    private PPickPath previousMouseFocus;
    private PPickPath mouseOver;
    private PPickPath previousMouseOver;
    private PInputEventListener keyboardFocus;
    private int pressedCount;

    public PInputManager() {
        lastCanvasPosition = new Point2D.Double();
        currentCanvasPosition = new Point2D.Double();
    }

    public PInputEventListener getKeyboardFocus() {
        return this.keyboardFocus;
    }

    public void setKeyboardFocus(PInputEventListener eventHandler) {
        PInputEvent focusEvent = new PInputEvent(this, null);
        if (this.keyboardFocus != null) {
            this.dispatchEventToListener(focusEvent, 1005, this.keyboardFocus);
        }
        this.keyboardFocus = eventHandler;
        if (this.keyboardFocus != null) {
            this.dispatchEventToListener(focusEvent, 1004, this.keyboardFocus);
        }
    }

    public PPickPath getMouseFocus() {
        return this.mouseFocus;
    }

    public void setMouseFocus(PPickPath path) {
        this.previousMouseFocus = this.mouseFocus;
        this.mouseFocus = path;
    }

    public PPickPath getMouseOver() {
        return this.mouseOver;
    }

    public void setMouseOver(PPickPath path) {
        this.mouseOver = path;
    }

    public Point2D getLastCanvasPosition() {
        return lastCanvasPosition;
    }

    public Point2D getCurrentCanvasPosition() {
        return currentCanvasPosition;
    }

    public void keyPressed(PInputEvent event) {
        this.dispatchEventToListener(event, 401, this.keyboardFocus);
    }

    public void keyReleased(PInputEvent event) {
        this.dispatchEventToListener(event, 402, this.keyboardFocus);
    }

    public void keyTyped(PInputEvent event) {
        this.dispatchEventToListener(event, 400, this.keyboardFocus);
    }

    public void mouseClicked(PInputEvent event) {
        this.dispatchEventToListener(event, 500, this.previousMouseFocus);
    }

    public void mouseWheelRotated(PInputEvent event) {
        this.setMouseFocus(this.getMouseOver());
        this.dispatchEventToListener(event, 0, this.mouseOver);
    }

    public void mouseWheelRotatedByBlock(PInputEvent event) {
        this.setMouseFocus(this.getMouseOver());
        this.dispatchEventToListener(event, 1, this.mouseOver);
    }

    public void mouseDragged(PInputEvent event) {
        this.checkForMouseEnteredAndExited(event);
        this.dispatchEventToListener(event, 506, this.mouseFocus);
    }

    public void mouseEntered(PInputEvent event) {
        this.dispatchEventToListener(event, 504, this.mouseOver);
    }

    public void mouseExited(PInputEvent event) {
        this.dispatchEventToListener(event, 505, this.previousMouseOver);
    }

    public void mouseMoved(PInputEvent event) {
        this.checkForMouseEnteredAndExited(event);
        this.dispatchEventToListener(event, 503, this.mouseOver);
    }

    public void mousePressed(PInputEvent event) {
        if (this.pressedCount == 0) {
            this.setMouseFocus(this.getMouseOver());
        }
        ++this.pressedCount;
        this.dispatchEventToListener(event, 501, this.mouseFocus);
        if (this.pressedCount < 1 || this.pressedCount > 3) {
            System.err.println("invalid pressedCount on mouse pressed: " + this.pressedCount);
        }
    }

    public void mouseReleased(PInputEvent event) {
        --this.pressedCount;
        this.checkForMouseEnteredAndExited(event);
        this.dispatchEventToListener(event, 502, this.mouseFocus);
        if (this.pressedCount == 0) {
            this.setMouseFocus(null);
        }
        if (this.pressedCount < 0 || this.pressedCount > 2) {
            System.err.println("invalid pressedCount on mouse released: " + this.pressedCount);
        }
    }

    protected void checkForMouseEnteredAndExited(PInputEvent event) {
        PNode p;
        PNode c = this.mouseOver != null ? this.mouseOver.getPickedNode() : null;
        PNode pNode = p = this.previousMouseOver != null ? this.previousMouseOver.getPickedNode() : null;
        if (c != p) {
            this.dispatchEventToListener(event, 505, this.previousMouseOver);
            this.dispatchEventToListener(event, 504, this.mouseOver);
            this.previousMouseOver = this.mouseOver;
        }
    }

    public void processInput() {
        if (this.nextInput == null) {
            return;
        }
        PInputEvent e = new PInputEvent(this, this.nextInput);
        if (e.isMouseEvent()) {
            lastCanvasPosition.setLocation(currentCanvasPosition);
            currentCanvasPosition.setLocation(((MouseEvent)this.nextInput).getX(), ((MouseEvent)this.nextInput).getY());
            PPickPath aPickPath = this.nextInputSource.pick(currentCanvasPosition.getX(), currentCanvasPosition.getY(), 1.0);
            this.setMouseOver(aPickPath);
        }
        this.processEvent(e, this.nextType);
        this.nextInput = null;
        this.nextInputSource = null;
    }

    public void processEventFromCamera(InputEvent event, int type, PCamera camera) {
        this.nextInput = event;
        this.nextType = type;
        this.nextInputSource = camera;
        camera.getRoot().processInputs();
    }

    private void dispatchEventToListener(PInputEvent event, int type, PInputEventListener listener) {
        if (listener != null) {
            event.setHandled(false);
            listener.processEvent(event, type);
        }
    }
}

