/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.hqcontrol;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.location.Location;
import de.hardcode.hq.location.LocationData;
import de.hardcode.hq.location.LocationListener;
import de.hardcode.hq.location.Locations;
import de.hardcode.time.Ticker;
import de.jpilot.game.Actor;
import de.jpilot.game.ActorHandler;
import de.jpilot.game.MotionData;
import javax.vecmath.Vector3f;

public class RemoteMovedHandler
implements LocationListener,
ActorHandler {
    private final Locations mLocations;
    private final Identity mIdentity;
    private final Vector3f LOOK_MINUS_Z = new Vector3f(0.0f, 0.0f, -1.0f);
    private final LocationData mLastKnown = new LocationData();
    private final MotionData mActorPos = new MotionData();

    public RemoteMovedHandler(Locations locations, Identity id) {
        this.mLocations = locations;
        this.mIdentity = id;
        this.mLocations.addListener(this);
    }

    public void close() {
        this.mLocations.removeListener(this);
    }

    public void update(Actor actor, Ticker ticker) {
        LocationData data = this.mLastKnown;
        Vector3f trans = new Vector3f();
        data.position().get(trans);
        this.LOOK_MINUS_Z.x = 0.0f;
        this.LOOK_MINUS_Z.y = 0.0f;
        this.LOOK_MINUS_Z.z = -1.0f;
        data.position().transform(this.LOOK_MINUS_Z);
        double alpha = Math.atan2(this.LOOK_MINUS_Z.x, this.LOOK_MINUS_Z.z) - 1.5707963267948966;
        this.mActorPos.x = trans.x;
        this.mActorPos.y = trans.z;
        this.mActorPos.vx = data.velocity().x;
        this.mActorPos.vy = data.velocity().z;
        this.mActorPos.ax = data.acceleration().x;
        this.mActorPos.ay = data.acceleration().z;
        this.mActorPos.alpha = (float)alpha;
        this.mActorPos.omega = data.spin().y;
        this.mActorPos.timestamp = data.getTimeStamp();
        actor.setMotionData(this.mActorPos);
    }

    public void changed(Location loc, int what, Object initiator) {
        if (loc.getIdentity().isSameAs(this.mIdentity)) {
            loc.getData(this.mLastKnown);
        }
    }

    public void created(Location which, Object initiator) {
    }

    public void eliminated(Location which, Object initiator) {
    }
}

