/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.hqcontrol;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.property.BooleanValue;
import de.hardcode.hq.property.IntegerValue;
import de.hardcode.hq.property.Properties;
import de.hardcode.hq.property.PropertySet;
import de.hardcode.hq.property.StringValue;
import de.jpilot.game.Actor;
import de.jpilot.game.Ship;
import de.jpilot.game.ShipListener;
import de.jpilot.hqcontrol.Initiators;
import de.jpilot.protocol.ID;

public class LocalPlayerPropertyMaintainer
implements ShipListener {
    private final Identity mIdentity;
    private final Properties mProperties;
    private final PropertySet mPropSet;
    private final StringValue mNameValue;
    private final BooleanValue mIsDeadValue;
    private final IntegerValue mKillsValue;
    private final IntegerValue mKilledValue;
    private final IntegerValue mBountyValue;

    public LocalPlayerPropertyMaintainer(Identity playerId, Properties props) {
        this.mIdentity = playerId;
        this.mProperties = props;
        this.mPropSet = this.mProperties.createPropertySet(this.mIdentity, Initiators.CLIENT);
        this.mPropSet.startUpdate(Initiators.CLIENT);
        this.mNameValue = new StringValue(this.mPropSet, ID.PLAYER_NAME);
        this.mIsDeadValue = new BooleanValue(this.mPropSet, ID.IS_DEAD);
        this.mKillsValue = new IntegerValue(this.mPropSet, ID.KILLS);
        this.mKilledValue = new IntegerValue(this.mPropSet, ID.KILLED);
        this.mBountyValue = new IntegerValue(this.mPropSet, ID.BOUNTY);
        this.mPropSet.finishUpdate();
    }

    public void closed(Actor actor) {
        this.mProperties.eliminate(this.mPropSet, this);
    }

    public void moved(Actor actor) {
    }

    public void died(Ship ship) {
        this.mPropSet.startUpdate(Initiators.CLIENT);
        this.mIsDeadValue.set(true);
        this.mKilledValue.add(1);
        this.mPropSet.finishUpdate();
    }

    public void spawned(Ship ship) {
        this.mPropSet.startUpdate(Initiators.CLIENT);
        this.mBountyValue.set(0);
        this.mIsDeadValue.set(false);
        this.mPropSet.finishUpdate();
    }

    public void killed(Ship ship, Ship whom) {
    }

    public void renamed(Ship ship) {
        this.mPropSet.startUpdate(Initiators.CLIENT);
        this.mNameValue.set(ship.getName());
        this.mPropSet.finishUpdate();
    }

    public void damaged(Ship ship, float howmuch, Ship who) {
    }

    public void changedStats(Ship ship) {
    }
}

