/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.hqcontrol;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.property.BooleanValue;
import de.hardcode.hq.property.IntegerValue;
import de.hardcode.hq.property.Properties;
import de.hardcode.hq.property.PropertyListener;
import de.hardcode.hq.property.PropertySet;
import de.hardcode.hq.property.StringValue;
import de.hardcode.hq.property.changes.Change;
import de.hardcode.hq.property.changes.Changes;
import de.hardcode.time.Ticker;
import de.jpilot.game.Actor;
import de.jpilot.game.ActorHandler;
import de.jpilot.game.Ship;
import de.jpilot.hqcontrol.Initiators;
import de.jpilot.protocol.ID;

public class LocalPlayerPropertyHandler
implements PropertyListener,
ActorHandler {
    private final Identity mIdentity;
    private final Properties mProperties;
    private String mChangeNameTo = null;
    private Boolean mIsDeadNow = null;
    private Integer mKilledStats = null;
    private Integer mKillsStats = null;
    private Integer mBounty = null;

    public LocalPlayerPropertyHandler(Identity playerId, Properties props) {
        this.mIdentity = playerId;
        this.mProperties = props;
        this.mProperties.addListener(this);
    }

    public void changed(PropertySet which, Object initiator) {
        if (initiator != Initiators.CLIENT && which.getIdentity().isSameAs(this.mIdentity)) {
            Changes changes = which.getChanges();
            int n = changes.getChangeCount();
            for (int i = 0; i < n; ++i) {
                Change chg = changes.getChange(i);
                if (chg.getValue().getIdentity().isSameAs(ID.PLAYER_NAME)) {
                    this.mChangeNameTo = ((StringValue)chg.getValue()).get();
                    continue;
                }
                if (chg.getValue().getIdentity().isSameAs(ID.IS_DEAD)) {
                    this.mIsDeadNow = ((BooleanValue)chg.getValue()).get();
                    continue;
                }
                if (chg.getValue().getIdentity().isSameAs(ID.KILLS)) {
                    this.mKillsStats = new Integer(((IntegerValue)chg.getValue()).get());
                    continue;
                }
                if (chg.getValue().getIdentity().isSameAs(ID.KILLED)) {
                    this.mKilledStats = new Integer(((IntegerValue)chg.getValue()).get());
                    continue;
                }
                if (!chg.getValue().getIdentity().isSameAs(ID.BOUNTY)) continue;
                this.mBounty = new Integer(((IntegerValue)chg.getValue()).get());
            }
        }
    }

    public void created(PropertySet which, Object initiator) {
    }

    public void eliminated(PropertySet which, Object initiator) {
    }

    public void close() {
        this.mProperties.removeListener(this);
    }

    public void update(Actor actor, Ticker ticker) {
        Ship ship = (Ship)actor;
        if (null != this.mChangeNameTo) {
            ship.setName(this.mChangeNameTo);
        }
        if (null != this.mIsDeadNow) {
            if (this.mIsDeadNow.booleanValue()) {
                ship.die();
            } else {
                ship.spawn();
            }
        }
        if (null != this.mKillsStats) {
            ship.getStatistics().setKills(this.mKillsStats);
        }
        if (null != this.mKilledStats) {
            ship.getStatistics().setKilled(this.mKilledStats);
        }
        if (null != this.mBounty) {
            ship.getStatistics().setBounty(this.mBounty);
        }
        this.mChangeNameTo = null;
        this.mIsDeadNow = null;
        this.mKillsStats = null;
        this.mKilledStats = null;
        this.mBounty = null;
    }
}

