/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.hqcontrol;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.location.Location;
import de.hardcode.hq.location.LocationData;
import de.hardcode.hq.location.Locations;
import de.hardcode.hq.location.motion.DeadReckoner;
import de.hardcode.hq.location.motion.EulerMotion;
import de.hardcode.hq.location.motion.Motion;
import de.jpilot.game.Actor;
import de.jpilot.game.ActorListener;
import de.jpilot.game.MotionData;
import javax.vecmath.Vector3f;

public class DeadReckonListener
implements ActorListener {
    private final Locations mLocations;
    private final Location mLocation;
    private final LocationData mLocData = new LocationData();
    private final Motion mRefMotion = new EulerMotion();
    private final DeadReckoner mDeadReckoner = new DeadReckoner(this.mRefMotion);

    public DeadReckonListener(Identity id, Locations locations) {
        this.mLocations = locations;
        this.mLocation = this.mLocations.createLocation(id, this);
    }

    public void closed(Actor actor) {
        this.mLocations.eliminate(this.mLocation, this);
    }

    public void moved(Actor actor) {
        MotionData data = actor.getMotionDataRef();
        long currenttime = data.timestamp;
        float deltaT = data.timestamp - this.mLocData.getTimeStamp();
        this.mLocData.spin().set(0.0f, data.omega, 0.0f);
        this.mLocData.velocity().set(data.vx, 0.0f, data.vy);
        this.mLocData.acceleration().set(data.ax, 0.0f, data.ay);
        this.mLocData.position().setIdentity();
        this.mLocData.position().rotY(data.alpha - 1.5707964f);
        Vector3f trans = new Vector3f(data.x, 0.0f, data.y);
        this.mLocData.position().setTranslation(trans);
        this.mLocData.setTimeStamp(currenttime);
        int what = this.mDeadReckoner.eval(this.mLocData, currenttime, deltaT);
        if (what != 0) {
            this.mLocation.startUpdate(this);
            this.mLocation.setData(this.mLocData, 15);
            this.mLocation.finishUpdate(currenttime);
        }
    }

    public void killed(Actor actor, Actor whom) {
    }
}

