/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.graphicsengine.piccolo;

import de.jpilot.graphicsengine.GraphicObject;
import edu.umd.cs.piccolo.PNode;

abstract class StdGraphicObject
implements GraphicObject {
    private final PNode mContainerNode;
    private final PNode mStdContent;
    private boolean mIsClosed = false;

    public StdGraphicObject(PNode container, PNode content) {
        this.mContainerNode = container;
        this.mStdContent = content;
        this.mContainerNode.addChild(this.mStdContent);
    }

    public boolean isClosed() {
        return this.mIsClosed;
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.mIsClosed = true;
        this.mContainerNode.removeChild(this.mStdContent);
    }

    public void move(float x, float y, float alpha) {
        this.mStdContent.setRotation(alpha);
        this.mStdContent.setOffset(x, y);
    }

    public void setName(String name) {
    }

    public void setVisible(boolean visibility) {
        this.getStdContent().setVisible(visibility);
    }

    PNode getContainerNode() {
        return this.mContainerNode;
    }

    PNode getStdContent() {
        return this.mStdContent;
    }
}

