/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.graphicsengine.piccolo;

import de.hardcode.hq.chat.client.ChatClient;
import de.hardcode.time.Ticking;
import de.jpilot.graphicsengine.Engine;
import de.jpilot.graphicsengine.GraphicObject;
import de.jpilot.graphicsengine.piccolo.Bullet;
import de.jpilot.graphicsengine.piccolo.BulletDetonationNode;
import de.jpilot.graphicsengine.piccolo.Console;
import de.jpilot.graphicsengine.piccolo.GridLayer;
import de.jpilot.graphicsengine.piccolo.InputLine;
import de.jpilot.graphicsengine.piccolo.PiccoloController;
import de.jpilot.graphicsengine.piccolo.Ship;
import de.jpilot.graphicsengine.piccolo.StdGraphicObject;
import de.jpilot.graphicsengine.piccolo.TickingActivity;
import edu.umd.cs.piccolo.PCanvas;
import java.awt.Color;
import java.awt.Dimension;

public class PiccoloEngine
extends PCanvas
implements Engine {
    private final Console mConsole = new Console(5);
    private InputLine mInputLine;
    private final TickingActivity mTicking = new TickingActivity();

    public PiccoloEngine(int width, int height) {
        new GridLayer(this);
        this.setPreferredSize(new Dimension(width, height));
        this.setBackground(Color.GREEN.darker().darker());
        this.setInteractingRenderQuality(1);
        this.setAnimatingRenderQuality(1);
        this.setDefaultRenderQuality(1);
        this.removeInputEventListener(this.getPanEventHandler());
        this.removeInputEventListener(this.getZoomEventHandler());
        this.mConsole.setOffset(5.0, (double)height - this.mConsole.getBoundsReference().getHeight() - 20.0);
        this.getCamera().addChild(this.mConsole);
        this.getRoot().addActivity(this.mTicking);
    }

    public void createChatInput(String playername, ChatClient chatclient) {
        this.mInputLine = new InputLine(this, playername, chatclient, this.mConsole);
    }

    public Ticking getTicking() {
        return this.mTicking;
    }

    public void render() {
    }

    public GraphicObject createGraphicObject(int type) {
        StdGraphicObject n = type == 0 ? new Ship(this.getLayer()) : new Bullet(this.getLayer());
        return n;
    }

    public void logMessage(String message) {
        this.mConsole.logMessage(message);
    }

    public void showBulletExplosion(double x, double y, double radius) {
        BulletDetonationNode b = new BulletDetonationNode(x, y, radius);
        this.getCamera().addChild(b);
        b.activate();
    }

    public PiccoloController createController() {
        PiccoloController c = new PiccoloController();
        this.addInputEventListener(c);
        this.getRoot().getDefaultInputManager().setKeyboardFocus(c);
        return c;
    }
}

