/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.graphicsengine.piccolo;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class GridLayer
extends PLayer {
    protected static Line2D gridLine = new Line2D.Double();
    protected static Stroke gridStroke = new BasicStroke(1.0f);
    protected static Color gridPaint = new Color(0, 150, 0);
    protected static double gridSpacing = 100.0;

    public GridLayer(PCanvas canvas) {
        PRoot root = canvas.getRoot();
        final PCamera camera = canvas.getCamera();
        root.removeChild(camera.getLayer(0));
        camera.removeLayer(0);
        root.addChild(this);
        camera.addLayer(this);
        camera.addPropertyChangeListener("bounds", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                GridLayer.this.setBounds(camera.getViewBounds());
            }
        });
        camera.addPropertyChangeListener("viewTransform", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                GridLayer.this.setBounds(camera.getViewBounds());
            }
        });
        this.setBounds(camera.getViewBounds());
    }

    protected void paint(PPaintContext paintContext) {
        double bx = this.getX() - this.getX() % gridSpacing - gridSpacing;
        double by = this.getY() - this.getY() % gridSpacing - gridSpacing;
        double rightBorder = this.getX() + this.getWidth() + gridSpacing;
        double bottomBorder = this.getY() + this.getHeight() + gridSpacing;
        Graphics2D g2 = paintContext.getGraphics();
        Rectangle2D clip = paintContext.getLocalClip();
        g2.setStroke(gridStroke);
        g2.setPaint(gridPaint);
        for (double x = bx; x < rightBorder; x += gridSpacing) {
            gridLine.setLine(x, by, x, bottomBorder);
            if (!clip.intersectsLine(gridLine)) continue;
            g2.draw(gridLine);
        }
        for (double y = by; y < bottomBorder; y += gridSpacing) {
            gridLine.setLine(bx, y, rightBorder, y);
            if (!clip.intersectsLine(gridLine)) continue;
            g2.draw(gridLine);
        }
    }
}

