/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.graphicsengine.piccolo;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;

public class Console
extends PNode {
    public static final Color TEXT_COLOR = Color.GREEN;
    private final PText[] mLines;
    private final int mNumLines;

    public Console(int numlines) {
        this.mNumLines = numlines;
        this.mLines = new PText[numlines];
        double height = 0.0;
        for (int i = 0; i < numlines; ++i) {
            this.mLines[i] = new PText(" ");
            this.mLines[i].setOffset(0.0, height);
            this.mLines[i].setTextPaint(TEXT_COLOR);
            this.addChild(this.mLines[i]);
            height += this.mLines[i].getBoundsReference().getHeight();
        }
        this.setBounds(0.0, 0.0, 50.0, height);
    }

    void shiftup() {
        for (int i = 0; i < this.mNumLines - 1; ++i) {
            this.mLines[i].setText(this.mLines[i + 1].getText());
        }
        this.mLines[this.mNumLines - 1].setText("");
    }

    public void logMessage(String message) {
        this.shiftup();
        this.mLines[this.mNumLines - 1].setText(message);
    }
}

