/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.graphicsengine.piccolo;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.Graphics2D;

public class BulletDetonationNode
extends PNode {
    private final double mRadius;
    private double mDone = 0.0;

    public BulletDetonationNode(double x, double y, double radius) {
        this.mRadius = radius;
        this.setOffset(x, y);
    }

    public void activate() {
        this.setDone(0.0);
        PActivity blow = new PActivity(500L){

            protected void activityStep(long elapsedTime) {
                super.activityStep(elapsedTime);
                BulletDetonationNode.this.setDone((double)elapsedTime / 500.0);
            }

            protected void activityFinished() {
                BulletDetonationNode.this.removeFromParent();
            }
        };
        this.addActivity(blow);
    }

    private void setDone(double done) {
        this.mDone = done;
        double rad = this.mRadius * done;
        this.setBounds(-rad, -rad, 2.0 * rad, 2.0 * rad);
    }

    public void paint(PPaintContext paintContext) {
        int rad = (int)(this.mRadius * this.mDone);
        Graphics2D g = paintContext.getGraphics();
        g.setPaint(new Color(1.0f, 1.0f - (float)this.mDone, 0.0f, 1.0f - (float)this.mDone));
        g.fillOval(-rad, -rad, 2 * rad, 2 * rad);
    }
}

