/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.game;

import de.jpilot.game.Actor;
import de.jpilot.game.ActorListener;
import de.jpilot.game.Game;
import de.jpilot.game.MotionData;
import de.jpilot.game.PlayerStatistics;
import de.jpilot.game.ShipListener;
import java.awt.Dimension;

public class Ship
extends Actor {
    private boolean mIsDead = true;
    private final PlayerStatistics mStatistics = new PlayerStatistics(this);
    String mName = null;
    private final Actor.Notifier DIED = new Actor.Notifier(){

        public void notify(ActorListener listener) {
            if (listener instanceof ShipListener) {
                ((ShipListener)listener).died(Ship.this);
            }
        }
    };
    private final Actor.Notifier SPAWNED = new Actor.Notifier(){

        public void notify(ActorListener listener) {
            if (listener instanceof ShipListener) {
                ((ShipListener)listener).spawned(Ship.this);
            }
        }
    };
    private final KilledNotifier KILLED = new KilledNotifier();
    private final Actor.Notifier RENAMED = new Actor.Notifier(){

        public void notify(ActorListener listener) {
            if (listener instanceof ShipListener) {
                ((ShipListener)listener).renamed(Ship.this);
            }
        }
    };
    private final DamagedNotifier DAMAGED = new DamagedNotifier();

    public Ship(Game game) {
        super(game);
    }

    public PlayerStatistics getStatistics() {
        return this.mStatistics;
    }

    public void die() {
        this.mIsDead = true;
        this.getStatistics().addKilled();
        this.notify(this.DIED);
    }

    public void spawn() {
        this.mIsDead = false;
        this.getStatistics().setBounty(0);
        this.notify(this.SPAWNED);
    }

    public boolean isDead() {
        return this.mIsDead;
    }

    public void killed(Ship whom) {
        this.getStatistics().addKills();
        this.getStatistics().addBounty(whom.getStatistics().getBounty() + 1);
        this.KILLED.set(whom);
        this.notify(this.KILLED);
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
        this.notify(this.RENAMED);
    }

    public void damage(float howmuch, Ship who) {
        this.DAMAGED.set(howmuch, who);
        this.notify(this.DAMAGED);
    }

    public void placeRandom() {
        Dimension mapsize = this.getGame().getMap().getSize();
        MotionData data = this.getMotionData();
        data.x = (float)(Math.random() * mapsize.getWidth());
        data.y = (float)(Math.random() * mapsize.getHeight());
        data.vx = 0.0f;
        data.vy = 0.0f;
        data.ax = 0.0f;
        data.ay = 0.0f;
        data.alpha = (float)(Math.random() * 2.0 * Math.PI);
        data.omega = 0.0f;
        this.setMotionData(data);
    }

    private class DamagedNotifier
    implements Actor.Notifier {
        private float mHowMuch;
        private Ship mWho;

        private DamagedNotifier() {
        }

        void set(float howmuch, Ship who) {
            this.mHowMuch = howmuch;
            this.mWho = who;
        }

        public void notify(ActorListener listener) {
            if (listener instanceof ShipListener) {
                ((ShipListener)listener).damaged(Ship.this, this.mHowMuch, this.mWho);
            }
        }
    }

    class KilledNotifier
    implements Actor.Notifier {
        private Ship mWhom;

        KilledNotifier() {
        }

        void set(Ship whom) {
            this.mWhom = whom;
        }

        public void notify(ActorListener listener) {
            if (listener instanceof ShipListener) {
                ((ShipListener)listener).killed(Ship.this, this.mWhom);
            }
        }
    }
}

