/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.game;

import de.jpilot.game.Actor;
import de.jpilot.game.ActorListener;
import de.jpilot.game.Ship;
import de.jpilot.game.ShipListener;

public class PlayerStatistics {
    private int mKilled = 0;
    private int mKills = 0;
    private int mBounty = 0;
    private final Ship mPlayer;
    private final Actor.Notifier STATS_CHANGED = new Actor.Notifier(){

        public void notify(ActorListener listener) {
            if (listener instanceof ShipListener) {
                ((ShipListener)listener).changedStats(PlayerStatistics.this.mPlayer);
            }
        }
    };

    public PlayerStatistics(Ship player) {
        this.mPlayer = player;
    }

    public int getKills() {
        return this.mKills;
    }

    public void setKills(int kills) {
        this.mKills = kills;
        this.mPlayer.notify(this.STATS_CHANGED);
    }

    public void addKills() {
        this.setKills(this.mKills + 1);
    }

    public int getKilled() {
        return this.mKilled;
    }

    public void setKilled(int killed) {
        this.mKilled = killed;
        this.mPlayer.notify(this.STATS_CHANGED);
    }

    public void addKilled() {
        this.setKilled(this.mKilled + 1);
    }

    public int getBounty() {
        return this.mBounty;
    }

    public void setBounty(int bounty) {
        this.mBounty = bounty;
        this.mPlayer.notify(this.STATS_CHANGED);
    }

    public void addBounty(int bounty) {
        this.setBounty(this.mBounty + bounty);
    }
}

