/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.game;

import de.hardcode.time.Ticker;
import de.jpilot.commands.Command;
import de.jpilot.commands.CommandQueue;
import de.jpilot.game.Actor;
import de.jpilot.game.Map;
import java.util.ArrayList;
import java.util.Iterator;

public class Game {
    private final Map mMap;
    private final CommandQueue mCommands = new CommandQueue();
    private final ArrayList mActors = new ArrayList();
    private Ticker mTicker = null;

    public Game(Map map) {
        this.mMap = map;
    }

    public synchronized void close() {
        Iterator it = this.getActors();
        while (it.hasNext()) {
            Actor a = (Actor)it.next();
            a.close();
        }
    }

    public final Map getMap() {
        return this.mMap;
    }

    public final CommandQueue getCommandQueue() {
        return this.mCommands;
    }

    public final Ticker getTicker() {
        return this.mTicker;
    }

    void addActor(Actor actor) {
        this.mCommands.add(new AddActor(actor));
    }

    void removeActor(Actor actor) {
        this.mCommands.add(new RemoveActor(actor));
    }

    Iterator getActors() {
        return this.mActors.iterator();
    }

    public synchronized void update(Ticker ticker) {
        this.mTicker = ticker;
        Iterator it = this.getActors();
        while (it.hasNext()) {
            Actor a = (Actor)it.next();
            a.update(ticker);
        }
        this.mCommands.update(ticker);
        this.mTicker = null;
    }

    class AddActor
    extends Command {
        private final Actor mActor;

        AddActor(Actor actor) {
            this.mActor = actor;
        }

        protected void execute(Ticker ticker) {
            Game.this.mActors.add(this.mActor);
            this.setState(1);
        }
    }

    class RemoveActor
    extends Command {
        private final Actor mActor;

        RemoveActor(Actor actor) {
            this.mActor = actor;
        }

        protected void execute(Ticker ticker) {
            Game.this.mActors.remove(this.mActor);
            this.setState(1);
        }
    }
}

