/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.game;

import de.hardcode.time.Ticker;
import de.jpilot.game.Actor;
import de.jpilot.game.ActorHandlerBase;
import de.jpilot.game.Bullet;
import de.jpilot.game.Game;
import de.jpilot.game.MotionData;
import de.jpilot.game.Ship;
import java.util.Iterator;

public class BulletHitHandler
extends ActorHandlerBase {
    private final float mHitRadius;
    private final float mHitRadiusSquared;
    public static final float DAMAGE_RADIUS = 30.0f;
    private static final float MAX_DAMAGE = 2.0f;

    public BulletHitHandler(float proximity) {
        this.mHitRadius = proximity;
        this.mHitRadiusSquared = this.mHitRadius * this.mHitRadius;
    }

    public void update(Actor actor, Ticker ticker) {
        Game g = actor.getGame();
        Iterator it = g.getActors();
        MotionData mypos = actor.getMotionDataRef();
        while (it.hasNext()) {
            Actor otheractor = (Actor)it.next();
            if (!(otheractor instanceof Ship)) continue;
            Ship ship = (Ship)otheractor;
            Bullet mybullet = (Bullet)actor;
            if (mybullet.getOwner() == ship) continue;
            MotionData otherpos = ship.getMotionDataRef();
            float dx = mypos.x - otherpos.x;
            float dy = mypos.y - otherpos.y;
            if (!(dx * dx + dy * dy < this.mHitRadiusSquared)) continue;
            mybullet.explode();
            mybullet.close();
            float dist = (float)Math.sqrt(dx * dx + dy * dy);
            float damage = 2.0f * ((30.0f - dist) / 30.0f);
            if (damage < 0.0f) {
                damage = 0.0f;
            }
            ship.damage(damage, mybullet.getOwner());
        }
    }
}

