/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.game;

import de.jpilot.game.Actor;
import de.jpilot.game.ActorListener;
import de.jpilot.game.BulletListener;
import de.jpilot.game.Game;
import de.jpilot.game.MotionData;
import de.jpilot.game.Ship;
import de.jpilot.game.TTLHandler;
import de.jpilot.movement.ConstantMovement;
import de.jpilot.movement.MovementHandler;

public class Bullet
extends Actor {
    private static final long BULLET_TTL = 2000L;
    private static final float BULLET_COST = 0.7f;
    public static final float DAMAGE_RADIUS = 30.0f;
    private static final float MAX_DAMAGE = 2.0f;
    private final Ship mOwner;
    private final long mStartTime;
    private final Actor.Notifier EXPLODED = new Actor.Notifier(){

        public void notify(ActorListener listener) {
            if (listener instanceof BulletListener) {
                ((BulletListener)listener).exploded(Bullet.this);
            }
        }
    };

    public Bullet(Game game, Ship whofired, MotionData initial) {
        super(game);
        this.mOwner = whofired;
        this.mStartTime = initial.timestamp;
        this.setMotionData(initial);
        this.setupHandlers();
    }

    public Ship getOwner() {
        return this.mOwner;
    }

    public static float getCost() {
        return 0.7f;
    }

    public void explode() {
        this.notify(this.EXPLODED);
    }

    private void setupHandlers() {
        ConstantMovement movement = new ConstantMovement();
        this.addHandler(new MovementHandler(movement));
        this.addHandler(new TTLHandler(this.mStartTime + 2000L));
    }
}

