/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.game;

import de.hardcode.time.Ticker;
import de.jpilot.game.ActorHandler;
import de.jpilot.game.ActorListener;
import de.jpilot.game.Game;
import de.jpilot.game.GameObject;
import de.jpilot.game.MotionData;
import java.util.ArrayList;

public class Actor
implements GameObject {
    private final Game mGame;
    protected MotionData mMotionData = new MotionData();
    private final ArrayList mHandlers = new ArrayList();
    private final ArrayList mListeners = new ArrayList();
    private final Notifier MOVED = new Notifier(){

        public void notify(ActorListener listener) {
            listener.moved(Actor.this);
        }
    };
    private final Notifier CLOSED = new Notifier(){

        public void notify(ActorListener listener) {
            listener.closed(Actor.this);
        }
    };

    public Actor(Game game) {
        this.mGame = game;
        this.mGame.addActor(this);
    }

    public void close() {
        this.mGame.removeActor(this);
        this.closeHandlers();
        this.notify(this.CLOSED);
    }

    public void update(Ticker ticker) {
        this.updateHandlers(ticker);
    }

    public Game getGame() {
        return this.mGame;
    }

    public void setMotionData(MotionData data) {
        this.mMotionData.set(data);
        this.notify(this.MOVED);
    }

    public MotionData getMotionData() {
        return new MotionData(this.mMotionData);
    }

    public void getMotionData(MotionData data) {
        this.mMotionData.get(data);
    }

    public MotionData getMotionDataRef() {
        return this.mMotionData;
    }

    protected void notify(Notifier not) {
        int cnt = this.mListeners.size();
        for (int i = cnt - 1; i >= 0; --i) {
            ActorListener l = (ActorListener)this.mListeners.get(i);
            not.notify(l);
        }
    }

    public void addHandler(ActorHandler handler) {
        this.mHandlers.add(handler);
    }

    public void removeHandler(ActorHandler handler) {
        this.mHandlers.remove(handler);
    }

    protected void updateHandlers(Ticker ticker) {
        int cnt = this.mHandlers.size();
        for (int i = 0; i < cnt; ++i) {
            ActorHandler h = (ActorHandler)this.mHandlers.get(i);
            h.update(this, ticker);
        }
    }

    protected void closeHandlers() {
        int cnt = this.mHandlers.size();
        for (int i = 0; i < cnt; ++i) {
            ActorHandler h = (ActorHandler)this.mHandlers.get(i);
            h.close();
        }
    }

    public void addListener(ActorListener listener) {
        this.mListeners.add(listener);
    }

    public void removeListener(ActorListener listener) {
        this.mListeners.remove(listener);
    }

    static interface Notifier {
        public void notify(ActorListener var1);
    }
}

