/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.client;

import de.hardcode.time.Ticker;
import de.jpilot.game.MotionData;
import de.jpilot.graphicsengine.Controller;
import de.jpilot.movement.Movement;

public class UserControlledMovement
implements Movement {
    private final Controller mController;
    private static final float SCALE_THRUST = 9.0E-5f;
    private static final float SCALE_ROT = -0.003f;
    private static final float MAX_SPEED = 0.08f;
    private float mAcceleration = 0.0f;
    private float mTurn = 0.0f;

    public UserControlledMovement(Controller controller) {
        this.mController = controller;
    }

    private void setAcceleration(float acc) {
        this.mAcceleration = acc;
    }

    private void setTurn(float turn) {
        this.mTurn = turn;
    }

    private void updateFromController() {
        this.setAcceleration(this.mController.getThrust());
        this.setTurn(this.mController.getSteer());
    }

    public void update(Ticker ticker, MotionData data) {
        this.updateFromController();
        float acc = this.mAcceleration * 9.0E-5f;
        float rot = this.mTurn * -0.003f;
        float dt = ticker.getTickTime() - data.timestamp;
        float alpha = data.alpha;
        float cos = (float)Math.cos(alpha += rot * dt);
        float sin = (float)Math.sin(alpha);
        float acc_displ = 0.5f * acc * dt * dt;
        float dx = data.vx * dt + acc_displ * cos;
        float dy = data.vy * dt + acc_displ * sin;
        data.vx += acc * cos * dt;
        data.vy += acc * sin * dt;
        data.ax = acc * cos;
        data.ay = acc * sin;
        float totalspeed = (float)Math.sqrt(data.vx * data.vx + data.vy * data.vy);
        if (totalspeed > 0.08f) {
            float scale = 0.08f / totalspeed;
            data.vx *= scale;
            data.vy *= scale;
            data.ax = 0.0f;
            data.ay = 0.0f;
        }
        data.x += dx;
        data.y += dy;
        data.alpha = alpha;
        data.omega = rot;
        data.timestamp = ticker.getTickTime();
    }
}

