/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.client;

import de.hardcode.hq.identity.Identity;
import de.jpilot.client.Client;
import de.jpilot.enginecontrol.ShipGraphicListener;
import de.jpilot.game.Ship;
import de.jpilot.hqcontrol.RemoteMovedHandler;
import de.jpilot.hqcontrol.RemotePlayerPropertyHandler;
import de.jpilot.hqcontrol.RemotePlayerPropertyMaintainer;
import de.jpilot.hqcontrol.RemoteRemovedHandler;
import de.jpilot.movement.ConstantMovement;
import de.jpilot.movement.CoordinateWrapperHandler;
import de.jpilot.movement.MovementHandler;
import java.awt.Dimension;

public class RemotePlayer {
    public static void create(Client clt, Identity id) {
        Ship ship = new Ship(clt.getGame());
        ship.addListener(new ShipGraphicListener(clt.getEngine().createGraphicObject(0)));
        ship.addListener(new RemotePlayerPropertyMaintainer(id, clt.getSubSystems().getProperties()));
        Dimension mapsize = clt.getGame().getMap().getSize();
        ship.addHandler(new CoordinateWrapperHandler(mapsize.width, mapsize.height));
        ship.addHandler(new RemoteRemovedHandler(clt.getSubSystems().getRegistry(), id));
        ship.addHandler(new RemoteMovedHandler(clt.getSubSystems().getLocations(), id));
        ship.addHandler(new MovementHandler(new ConstantMovement()));
        ship.addHandler(new RemotePlayerPropertyHandler(id, clt.getSubSystems().getProperties()));
        ship.addHandler(clt.getEventManager().createRemoteFireHandler(id));
        ship.spawn();
    }
}

