/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.client;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.objectbus.BusLine;
import de.hardcode.hq.objectbus.BusStation;
import de.hardcode.hq.objectbus.BusTicket;
import de.hardcode.hq.objectbus.BusTicketListener;
import de.hardcode.time.Ticker;
import de.jpilot.client.Client;
import de.jpilot.client.RemoteBullet;
import de.jpilot.game.Actor;
import de.jpilot.game.ActorHandler;
import de.jpilot.game.MotionData;
import de.jpilot.game.Ship;
import de.jpilot.hqcontrol.BulletFiredEvent;
import de.jpilot.protocol.ID;

public class RemoteFireHandler
implements ActorHandler,
BusTicketListener {
    private final Client mClient;
    private final Identity mActorID;
    private final BusStation mBusStation;
    private MotionData mDataForBullet = null;
    private final MotionData mDecodeData = new MotionData();

    public RemoteFireHandler(Client clt, Identity actorid, BusStation busstation) {
        this.mClient = clt;
        this.mActorID = actorid;
        this.mBusStation = busstation;
        this.mBusStation.add(ID.PUBLIC_EVENTS, this);
    }

    public void arrived(BusLine l, BusTicket t) {
        Identity id;
        Identity evtid = t.getID();
        if (evtid.isSameAs(ID.BULLET_FIRED) && (id = BulletFiredEvent.decode(t, this.mDecodeData)).isSameAs(this.mActorID)) {
            this.mDecodeData.omega = 0.01f;
            this.mDataForBullet = this.mDecodeData;
        }
    }

    public void close() {
        this.mBusStation.remove(ID.PUBLIC_EVENTS, this);
    }

    public void update(Actor actor, Ticker ticker) {
        if (null != this.mDataForBullet) {
            RemoteBullet.create(this.mClient, (Ship)actor, this.mDataForBullet);
            this.mDataForBullet = null;
        }
    }
}

