/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.client;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.identity.NamedIdentity;
import de.jpilot.client.Client;
import de.jpilot.client.EnergyRechargeHandler;
import de.jpilot.client.LocalBullet;
import de.jpilot.client.LocalDamageListener;
import de.jpilot.client.LocalFireHandler;
import de.jpilot.client.UserControlledMovement;
import de.jpilot.enginecontrol.LocalShipGraphicListener;
import de.jpilot.game.Bullet;
import de.jpilot.game.Ship;
import de.jpilot.hqcontrol.DeadReckonListener;
import de.jpilot.hqcontrol.LocalPlayerPropertyHandler;
import de.jpilot.hqcontrol.LocalPlayerPropertyMaintainer;
import de.jpilot.hqcontrol.LocalPlayerRegistryMaintainer;
import de.jpilot.movement.CoordinateWrapperHandler;
import de.jpilot.movement.MovementHandler;
import java.awt.Dimension;

public class LocalPlayer {
    private final Client mClient;
    private final Ship mShip;
    private float mEnergy = 1.0f;
    private static final float MAX_ENERGY = 1.0f;
    private static final float RECHARGE_RATE = 4.0E-4f;
    private final Identity mIdentity;

    public LocalPlayer(Client clt) {
        this.mClient = clt;
        this.mShip = new Ship(clt.getGame());
        this.mIdentity = new NamedIdentity(clt.getUserInfo().name);
        this.mShip.addListener(new LocalShipGraphicListener(clt.getEngine().createGraphicObject(0)));
        this.mShip.addListener(new DeadReckonListener(this.mIdentity, clt.getSubSystems().getLocations()));
        this.mShip.addListener(new LocalPlayerRegistryMaintainer(this.mIdentity, clt.getSubSystems().getRegistry()));
        this.mShip.addListener(new LocalPlayerPropertyMaintainer(this.mIdentity, clt.getSubSystems().getProperties()));
        this.mShip.addListener(new LocalDamageListener(this));
        this.mShip.addHandler(new MovementHandler(new UserControlledMovement(clt.getController())));
        Dimension mapsize = clt.getGame().getMap().getSize();
        this.mShip.addHandler(new CoordinateWrapperHandler(mapsize.width, mapsize.height));
        this.mShip.addHandler(new EnergyRechargeHandler(this, 4.0E-4f, 1.0f));
        this.mShip.addHandler(new LocalFireHandler(this, clt.getController()));
        this.mShip.addHandler(new LocalPlayerPropertyHandler(this.mIdentity, clt.getSubSystems().getProperties()));
        this.mShip.setName(clt.getUserInfo().name);
        this.mShip.placeRandom();
        this.mShip.spawn();
    }

    float getEnergy() {
        return this.mEnergy;
    }

    float changeEnergy(float amount) {
        this.mEnergy += amount;
        if (this.mEnergy > 1.0f) {
            this.mEnergy = 1.0f;
        }
        return this.mEnergy;
    }

    void resetEnergy() {
        this.mEnergy = 1.0f;
    }

    void fireBullet() {
        LocalBullet.create(this.mClient, this.mShip, this.mIdentity);
        this.changeEnergy(-Bullet.getCost());
    }
}

