/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.client;

import de.hardcode.hq.identity.Identity;
import de.jpilot.client.Client;
import de.jpilot.enginecontrol.BulletGraphicListener;
import de.jpilot.game.Bullet;
import de.jpilot.game.BulletHitHandler;
import de.jpilot.game.MotionData;
import de.jpilot.game.Ship;
import de.jpilot.hqcontrol.BulletFiredEvent;
import de.jpilot.movement.CoordinateWrapperHandler;
import java.awt.Dimension;

public class LocalBullet {
    private static final float BULLET_SPEED = 0.2f;
    public static final float BULLET_ROTSPEED = 0.01f;
    private static final BulletFiredEvent BULLET_FIRED_EVENT = new BulletFiredEvent();

    public static void create(Client clt, Ship whofired, Identity ownerID) {
        MotionData initialpos = LocalBullet.prepareInitialMotionData(whofired.getMotionData());
        Bullet bullet = new Bullet(clt.getGame(), whofired, initialpos);
        bullet.addListener(new BulletGraphicListener(clt.getEngine(), clt.getEngine().createGraphicObject(1)));
        Dimension mapsize = clt.getGame().getMap().getSize();
        bullet.addHandler(new CoordinateWrapperHandler(mapsize.width, mapsize.height));
        bullet.addHandler(new BulletHitHandler(8.0f));
        BULLET_FIRED_EVENT.set(bullet, ownerID);
        clt.getEventManager().sendEvent(BULLET_FIRED_EVENT);
    }

    private static MotionData prepareInitialMotionData(MotionData initial) {
        initial.vx += 0.2f * (float)Math.cos(initial.alpha);
        initial.vy += 0.2f * (float)Math.sin(initial.alpha);
        initial.omega = 0.01f;
        initial.ax = 0.0f;
        initial.ay = 0.0f;
        return initial;
    }
}

