/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.client;

import de.hardcode.time.Clock;
import de.hardcode.time.SystemClock;
import de.hardcode.time.Ticker;
import de.hardcode.time.TickerListener;
import de.hardcode.time.Ticking;
import de.hardcode.time.TickingThread;
import de.jpilot.client.BusStationBinding;
import de.jpilot.client.Log;
import de.jpilot.game.Game;
import de.jpilot.graphicsengine.Engine;

public class GameLoop
implements TickerListener {
    private static final long CLOCK_RESYNC_INTERVAL = 60000L;
    private final Ticking mTicking;
    private final Game mGame;
    private final Engine mEngine;
    private final BusStationBinding mStationBinding;
    private long mLastClockResync = 0L;

    public GameLoop(long interval, Game game, Engine engine, BusStationBinding stationbinding) {
        this.mGame = game;
        this.mEngine = engine;
        this.mStationBinding = stationbinding;
        this.mTicking = new TickingThread(new SystemClock(), new Ticker(), interval);
    }

    public GameLoop(Ticking ticking, Game game, Engine engine, BusStationBinding stationbinding) {
        this.mTicking = ticking;
        this.mGame = game;
        this.mEngine = engine;
        this.mStationBinding = stationbinding;
    }

    public Clock getClock() {
        return this.mTicking.getClock();
    }

    public void start() {
        this.mTicking.getTicker().addClockListener(this);
        this.mTicking.startTicking();
    }

    public void stop() {
        this.mStationBinding.getBusStation().flush();
        this.mTicking.stopTicking();
        this.mTicking.getTicker().removeClockListener(this);
    }

    public void reset(Ticker ticker) {
    }

    public void tick(Ticker ticker) {
        if (ticker.getTickTime() - this.mLastClockResync > 60000L) {
            this.mEngine.logMessage("Latest ping time was " + this.mStationBinding.getLastPingValue() + "ms");
            this.mStationBinding.resyncClock();
            this.mLastClockResync = ticker.getTickTime();
            Log.logger.info("Resync clock.");
        }
        this.mGame.update(ticker);
        this.mStationBinding.getBusStation().flush();
        this.mEngine.render();
    }
}

