/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.client;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.objectbus.BusStation;
import de.jpilot.client.Client;
import de.jpilot.client.RemoteFireHandler;
import de.jpilot.hqcontrol.HQEvent;
import de.jpilot.hqcontrol.Log;

public class EventManager {
    private final BusStation mBusStation;
    private final Client mClient;

    public EventManager(Client clt) {
        this.mClient = clt;
        this.mBusStation = clt.getBusStationBinding().getBusStation();
    }

    public void close() {
        Log.logger.info("Closing EventController");
    }

    public void sendEvent(HQEvent evt) {
        this.mBusStation.broadcast(evt, null);
    }

    public RemoteFireHandler createRemoteFireHandler(Identity actorID) {
        return new RemoteFireHandler(this.mClient, actorID, this.mBusStation);
    }
}

