/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.client;

import de.jpilot.client.BusStationBinding;
import de.jpilot.client.EventManager;
import de.jpilot.client.GameLoop;
import de.jpilot.client.LocalPlayer;
import de.jpilot.client.Log;
import de.jpilot.client.RemotePlayerManager;
import de.jpilot.client.UserInfo;
import de.jpilot.game.Game;
import de.jpilot.game.Map;
import de.jpilot.graphicsengine.Controller;
import de.jpilot.graphicsengine.Engine;
import de.jpilot.graphicsengine.piccolo.PiccoloEngine;
import de.jpilot.hqcontrol.PropertyController;
import de.jpilot.hqcontrol.RegistrySetup;
import de.jpilot.protocol.SubSystems;
import java.net.InetAddress;

public class Client {
    private final PiccoloEngine mEngine;
    private final Controller mController;
    private final UserInfo mUserInfo;
    private final Game mGame;
    private PropertyController mPropertyController;
    private EventManager mEventManager;
    private final GameLoop mGameLoop;
    private final BusStationBinding mBusStationBinding;
    private final SubSystems mSubSystems;
    private final RemotePlayerManager mRemotePlayerManager;

    public Client(PiccoloEngine engine, Controller ctrl, UserInfo userinfo) {
        this.mEngine = engine;
        this.mController = ctrl;
        this.mUserInfo = userinfo;
        Map map = new Map();
        this.mGame = new Game(map);
        this.mSubSystems = new SubSystems();
        RegistrySetup.initializeRegistry(this.mSubSystems.getRegistry());
        this.mPropertyController = new PropertyController(this.mGame, this.mSubSystems.getProperties());
        this.mBusStationBinding = new BusStationBinding(this.mSubSystems);
        this.mEventManager = new EventManager(this);
        this.mRemotePlayerManager = new RemotePlayerManager(this);
        this.mEngine.logMessage("Welcome to JPilot 0.2!");
        this.mEngine.logMessage("Use cursor keys to steer, <space> to fire, <tab> to chat.");
        this.mEngine.logMessage("Have fun and send comments to plewe@hardcode.de .");
        this.mGameLoop = new GameLoop(this.mEngine.getTicking(), this.mGame, (Engine)this.mEngine, this.mBusStationBinding);
    }

    public Game getGame() {
        return this.mGame;
    }

    public Engine getEngine() {
        return this.mEngine;
    }

    public Controller getController() {
        return this.mController;
    }

    public SubSystems getSubSystems() {
        return this.mSubSystems;
    }

    public UserInfo getUserInfo() {
        return this.mUserInfo;
    }

    public EventManager getEventManager() {
        return this.mEventManager;
    }

    public BusStationBinding getBusStationBinding() {
        return this.mBusStationBinding;
    }

    public final boolean connect(InetAddress server, int port) {
        boolean connected = this.mBusStationBinding.connect(server, port, this.mGameLoop.getClock());
        if (connected) {
            this.mEngine.createChatInput(this.mUserInfo.name, this.mBusStationBinding.getChatClient());
            this.mGameLoop.start();
            this.mBusStationBinding.download();
            new LocalPlayer(this);
        }
        return connected;
    }

    public void close() {
        Log.logger.info("Closing ClientManager");
        this.mGame.close();
        this.mGameLoop.stop();
        this.mRemotePlayerManager.close();
        this.mPropertyController.close();
        this.mEventManager.close();
        this.mBusStationBinding.close();
        this.mSubSystems.close();
    }
}

